"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disableRuleRoute = void 0;
var _disable = require("../../../../../common/routes/rule/apis/disable");
var _lib = require("../../../../lib");
var _types = require("../../../../types");
var _lib2 = require("../../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disableRuleRoute = (router, licenseState) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}/_disable`,
    options: {
      access: 'public',
      summary: 'Disable a rule',
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {
        params: _disable.disableRuleRequestParamsSchemaV1,
        body: _disable.disableRuleRequestBodySchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given ID does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const {
      id
    } = req.params;
    const body = req.body || {};
    const {
      untrack = false
    } = body;
    const disableParams = {
      id,
      untrack
    };
    try {
      await rulesClient.disableRule(disableParams);
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.disableRuleRoute = disableRuleRoute;