"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteRuleRoute = void 0;
var _lib = require("../../../lib");
var _delete = require("../../../../../common/routes/rule/apis/delete");
var _types = require("../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteRuleRoute = (router, licenseState) => {
  router.delete({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}`,
    options: {
      access: 'public',
      summary: `Delete a rule`,
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {
        params: _delete.deleteRuleRequestParamsSchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given ID does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const params = req.params;
    await rulesClient.delete({
      id: params.id
    });
    return res.noContent();
  })));
};
exports.deleteRuleRoute = deleteRuleRoute;