"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkEditInternalRulesRoute = void 0;
var _lib = require("../../../../lib");
var _types = require("../../../../types");
var _lib2 = require("../../../lib");
var _bulk_edit = require("../../../../../common/routes/rule/apis/bulk_edit");
var _transforms = require("../../transforms");
var _validation = require("../../validation");
var _transforms2 = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildBulkEditRulesRoute = ({
  licenseState,
  path,
  router
}) => {
  router.post({
    path,
    options: {
      access: 'internal'
    },
    validate: {
      body: _bulk_edit.bulkEditRulesRequestBodySchemaV1
    }
  }, (0, _lib2.handleDisabledApiKeysError)(router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const actionsClient = (await context.actions).getActionsClient();
    const bulkEditData = req.body;
    const {
      filter,
      operations,
      ids
    } = bulkEditData;
    try {
      validateRequiredGroupInDefaultActionsInOperations(operations !== null && operations !== void 0 ? operations : [], connectorId => actionsClient.isSystemAction(connectorId));
      const bulkEditResults = await rulesClient.bulkEdit({
        filter,
        ids,
        operations: (0, _transforms2.transformOperationsV1)({
          operations,
          isSystemAction: connectorId => actionsClient.isSystemAction(connectorId)
        })
      });
      const resultBody = {
        body: {
          ...bulkEditResults,
          rules: bulkEditResults.rules.map(rule => {
            // TODO (http-versioning): Remove this cast, this enables us to move forward
            // without fixing all of other solution types
            return (0, _transforms.transformRuleToRuleResponseV1)(rule);
          })
        }
      };
      return res.ok(resultBody);
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  }))));
};
const bulkEditInternalRulesRoute = (router, licenseState) => buildBulkEditRulesRoute({
  licenseState,
  path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_edit`,
  router
});
exports.bulkEditInternalRulesRoute = bulkEditInternalRulesRoute;
const validateRequiredGroupInDefaultActionsInOperations = (operations, isSystemAction) => {
  for (const operation of operations) {
    if (operation.field === 'actions') {
      (0, _validation.validateRequiredGroupInDefaultActionsV1)({
        actions: operation.value,
        isSystemAction
      });
    }
  }
};