"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMaintenanceWindowRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _common = require("../../../../../common");
var _update = require("../../../../../common/routes/maintenance_window/apis/update");
var _transforms = require("./transforms");
var _transforms2 = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/{id}`,
    validate: {
      body: _update.updateBodySchemaV1,
      params: _update.updateParamsSchemaV1
    },
    options: {
      access: 'internal',
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const body = req.body;
    const params = req.params;
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const maintenanceWindow = await maintenanceWindowClient.update({
      id: params.id,
      data: (0, _transforms.transformUpdateBodyV1)(body)
    });
    const response = {
      body: (0, _transforms2.transformMaintenanceWindowToResponseV1)(maintenanceWindow)
    };
    return res.ok(response);
  })));
};
exports.updateMaintenanceWindowRoute = updateMaintenanceWindowRoute;