"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.finishMaintenanceWindowRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _finish = require("../../../../../common/routes/maintenance_window/apis/finish");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const finishMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/{id}/_finish`,
    validate: {
      params: _finish.finishParamsSchemaV1
    },
    options: {
      access: 'internal',
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const params = req.params;
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const maintenanceWindow = await maintenanceWindowClient.finish({
      id: params.id
    });
    const response = {
      body: (0, _transforms.transformMaintenanceWindowToResponseV1)(maintenanceWindow)
    };
    return res.ok(response);
  })));
};
exports.finishMaintenanceWindowRoute = finishMaintenanceWindowRoute;