"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindowRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _common = require("../../../../../common");
var _create = require("../../../../../common/routes/maintenance_window/apis/create");
var _transforms = require("./transforms");
var _transforms2 = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMaintenanceWindowRoute = (router, licenseState) => {
  router.post({
    path: _types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH,
    validate: {
      body: _create.createBodySchemaV1
    },
    options: {
      access: 'internal',
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.WRITE_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const body = req.body;
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const maintenanceWindow = await maintenanceWindowClient.create({
      data: (0, _transforms.transformCreateBodyV1)(body)
    });
    const response = {
      body: (0, _transforms2.transformMaintenanceWindowToResponseV1)(maintenanceWindow)
    };
    return res.ok(response);
  })));
};
exports.createMaintenanceWindowRoute = createMaintenanceWindowRoute;