"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlappingSettingsRoute = void 0;
var _types = require("../types");
var _lib = require("./lib");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  lookBackWindow,
  statusChangeThreshold,
  createdBy,
  updatedBy,
  createdAt,
  updatedAt,
  ...rest
}) => ({
  ...rest,
  look_back_window: lookBackWindow,
  status_change_threshold: statusChangeThreshold,
  created_by: createdBy,
  updated_by: updatedBy,
  created_at: createdAt,
  updated_at: updatedAt
});
const getFlappingSettingsRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_flapping`,
    validate: false,
    options: {
      access: 'internal',
      tags: [`access:${_common.API_PRIVILEGES.READ_FLAPPING_SETTINGS}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesSettingsClient = (await context.alerting).getRulesSettingsClient();
    const flappingSettings = await rulesSettingsClient.flapping().get();
    return res.ok({
      body: rewriteBodyRes(flappingSettings)
    });
  })));
};
exports.getFlappingSettingsRoute = getFlappingSettingsRoute;