"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleBackfillRoute = void 0;
var _schedule = require("../../../../../common/routes/backfill/apis/schedule");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleBackfillRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/backfill/_schedule`,
    options: {
      access: 'internal'
    },
    validate: {
      body: _schedule.scheduleBodySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const body = req.body;
    const result = await rulesClient.scheduleBackfill((0, _transforms.transformRequestV1)(body));
    const response = {
      body: (0, _transforms.transformResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.scheduleBackfillRoute = scheduleBackfillRoute;