"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidConsumer = exports.WriteOperations = exports.ReadOperations = exports.AlertingAuthorizationEntity = exports.AlertingAuthorization = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _types = require("../types");
var _alerting_authorization_kuery = require("./alerting_authorization_kuery");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AlertingAuthorizationEntity = exports.AlertingAuthorizationEntity = /*#__PURE__*/function (AlertingAuthorizationEntity) {
  AlertingAuthorizationEntity["Rule"] = "rule";
  AlertingAuthorizationEntity["Alert"] = "alert";
  return AlertingAuthorizationEntity;
}({});
let ReadOperations = exports.ReadOperations = /*#__PURE__*/function (ReadOperations) {
  ReadOperations["Get"] = "get";
  ReadOperations["GetRuleState"] = "getRuleState";
  ReadOperations["GetAlertSummary"] = "getAlertSummary";
  ReadOperations["GetExecutionLog"] = "getExecutionLog";
  ReadOperations["GetActionErrorLog"] = "getActionErrorLog";
  ReadOperations["Find"] = "find";
  ReadOperations["GetAuthorizedAlertsIndices"] = "getAuthorizedAlertsIndices";
  ReadOperations["GetRuleExecutionKPI"] = "getRuleExecutionKPI";
  ReadOperations["GetBackfill"] = "getBackfill";
  ReadOperations["FindBackfill"] = "findBackfill";
  return ReadOperations;
}({});
let WriteOperations = exports.WriteOperations = /*#__PURE__*/function (WriteOperations) {
  WriteOperations["Create"] = "create";
  WriteOperations["Delete"] = "delete";
  WriteOperations["Update"] = "update";
  WriteOperations["UpdateApiKey"] = "updateApiKey";
  WriteOperations["Enable"] = "enable";
  WriteOperations["Disable"] = "disable";
  WriteOperations["MuteAll"] = "muteAll";
  WriteOperations["UnmuteAll"] = "unmuteAll";
  WriteOperations["MuteAlert"] = "muteAlert";
  WriteOperations["UnmuteAlert"] = "unmuteAlert";
  WriteOperations["Snooze"] = "snooze";
  WriteOperations["BulkEdit"] = "bulkEdit";
  WriteOperations["BulkDelete"] = "bulkDelete";
  WriteOperations["BulkEnable"] = "bulkEnable";
  WriteOperations["BulkDisable"] = "bulkDisable";
  WriteOperations["Unsnooze"] = "unsnooze";
  WriteOperations["RunSoon"] = "runSoon";
  WriteOperations["ScheduleBackfill"] = "scheduleBackfill";
  WriteOperations["DeleteBackfill"] = "deleteBackfill";
  return WriteOperations;
}({});
const DISCOVER_FEATURE_ID = 'discover';
class AlertingAuthorization {
  constructor({
    ruleTypeRegistry,
    request,
    authorization,
    features,
    getSpace,
    getSpaceId
  }) {
    (0, _defineProperty2.default)(this, "ruleTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "request", void 0);
    (0, _defineProperty2.default)(this, "authorization", void 0);
    (0, _defineProperty2.default)(this, "featuresIds", void 0);
    (0, _defineProperty2.default)(this, "allPossibleConsumers", void 0);
    (0, _defineProperty2.default)(this, "spaceId", void 0);
    (0, _defineProperty2.default)(this, "features", void 0);
    this.request = request;
    this.authorization = authorization;
    this.ruleTypeRegistry = ruleTypeRegistry;
    this.features = features;
    this.spaceId = getSpaceId(request);
    this.featuresIds = getSpace(request).then(maybeSpace => {
      var _maybeSpace$disabledF;
      return new Set((_maybeSpace$disabledF = maybeSpace === null || maybeSpace === void 0 ? void 0 : maybeSpace.disabledFeatures) !== null && _maybeSpace$disabledF !== void 0 ? _maybeSpace$disabledF : []);
    }).then(disabledFeatures => new Set(features.getKibanaFeatures().filter(({
      id,
      alerting
    }) => {
      var _alerting$length;
      return (
        // ignore features which are disabled in the user's space
        !disabledFeatures.has(id) && ( // ignore features which don't grant privileges to alerting
        (_alerting$length = alerting === null || alerting === void 0 ? void 0 : alerting.length) !== null && _alerting$length !== void 0 ? _alerting$length : 0 > 0)
      );
    }).map(feature => feature.id))).catch(() => {
      // failing to fetch the space means the user is likely not privileged in the
      // active space at all, which means that their list of features should be empty
      return new Set();
    });
    this.allPossibleConsumers = this.featuresIds.then(featuresIds => {
      return featuresIds.size ? asAuthorizedConsumers([_types.ALERTING_FEATURE_ID, DISCOVER_FEATURE_ID, ...featuresIds], {
        read: true,
        all: true
      }) : {};
    });
  }
  shouldCheckAuthorization() {
    var _this$authorization$m, _this$authorization, _this$authorization$m2;
    return (_this$authorization$m = (_this$authorization = this.authorization) === null || _this$authorization === void 0 ? void 0 : (_this$authorization$m2 = _this$authorization.mode) === null || _this$authorization$m2 === void 0 ? void 0 : _this$authorization$m2.useRbacForRequest(this.request)) !== null && _this$authorization$m !== void 0 ? _this$authorization$m : false;
  }
  getSpaceId() {
    return this.spaceId;
  }

  /*
   * This method exposes the private 'augmentRuleTypesWithAuthorization' to be
   * used by the RAC/Alerts client
   */
  async getAugmentedRuleTypesWithAuthorization(featureIds, operations, authorizationEntity) {
    return this.augmentRuleTypesWithAuthorization(this.ruleTypeRegistry.list(), operations, authorizationEntity, new Set(featureIds));
  }
  async ensureAuthorized({
    ruleTypeId,
    consumer: legacyConsumer,
    operation,
    entity,
    additionalPrivileges = []
  }) {
    const {
      authorization
    } = this;
    const ruleType = this.ruleTypeRegistry.get(ruleTypeId);
    const consumer = getValidConsumer({
      validLegacyConsumers: ruleType.validLegacyConsumers,
      legacyConsumer,
      producer: ruleType.producer
    });
    const isAvailableConsumer = (0, _lodash.has)(await this.allPossibleConsumers, consumer);
    if (authorization && this.shouldCheckAuthorization()) {
      const checkPrivileges = authorization.checkPrivilegesDynamicallyWithRequest(this.request);
      const {
        hasAllRequested
      } = await checkPrivileges({
        kibana: [authorization.actions.alerting.get(ruleTypeId, consumer, entity, operation), ...additionalPrivileges]
      });
      if (!isAvailableConsumer) {
        /**
         * Under most circumstances this would have been caught by `checkPrivileges` as
         * a user can't have Privileges to an unknown consumer, but super users
         * don't actually get "privilege checked" so the made up consumer *will* return
         * as Privileged.
         * This check will ensure we don't accidentally let these through
         */
        throw _boom.default.forbidden(getUnauthorizedMessage(ruleTypeId, legacyConsumer, operation, entity));
      }
      if (!hasAllRequested) {
        throw _boom.default.forbidden(getUnauthorizedMessage(ruleTypeId, consumer, operation, entity));
      }
    } else if (!isAvailableConsumer) {
      throw _boom.default.forbidden(getUnauthorizedMessage(ruleTypeId, consumer, operation, entity));
    }
  }
  async getFindAuthorizationFilter(authorizationEntity, filterOpts, featuresIds) {
    return this.getAuthorizationFilter(authorizationEntity, filterOpts, ReadOperations.Find, featuresIds);
  }
  async getAuthorizedRuleTypes(authorizationEntity, featuresIds) {
    const {
      authorizedRuleTypes
    } = await this.augmentRuleTypesWithAuthorization(this.ruleTypeRegistry.list(), [ReadOperations.Find], authorizationEntity, featuresIds);
    return Array.from(authorizedRuleTypes);
  }
  async getAuthorizationFilter(authorizationEntity, filterOpts, operation, featuresIds) {
    if (this.authorization && this.shouldCheckAuthorization()) {
      const {
        authorizedRuleTypes
      } = await this.augmentRuleTypesWithAuthorization(this.ruleTypeRegistry.list(), [operation], authorizationEntity, featuresIds);
      if (!authorizedRuleTypes.size) {
        throw _boom.default.forbidden(`Unauthorized to find ${authorizationEntity}s for any rule types`);
      }
      const authorizedRuleTypeIdsToConsumers = new Set([...authorizedRuleTypes].reduce((ruleTypeIdConsumerPairs, ruleType) => {
        for (const consumer of Object.keys(ruleType.authorizedConsumers)) {
          ruleTypeIdConsumerPairs.push(`${ruleType.id}/${consumer}/${authorizationEntity}`);
        }
        return ruleTypeIdConsumerPairs;
      }, []));
      const authorizedEntries = new Map();
      return {
        filter: (0, _alerting_authorization_kuery.asFiltersByRuleTypeAndConsumer)(authorizedRuleTypes, filterOpts, this.spaceId),
        ensureRuleTypeIsAuthorized: (ruleTypeId, consumer, authType) => {
          if (!authorizedRuleTypeIdsToConsumers.has(`${ruleTypeId}/${consumer}/${authType}`)) {
            throw _boom.default.forbidden(getUnauthorizedMessage(ruleTypeId, consumer, 'find', authorizationEntity));
          } else {
            if (authorizedEntries.has(ruleTypeId)) {
              authorizedEntries.get(ruleTypeId).add(consumer);
            } else {
              authorizedEntries.set(ruleTypeId, new Set([consumer]));
            }
          }
        }
      };
    }
    return {
      filter: (0, _alerting_authorization_kuery.asFiltersBySpaceId)(filterOpts, this.spaceId),
      ensureRuleTypeIsAuthorized: (ruleTypeId, consumer, authType) => {}
    };
  }
  async filterByRuleTypeAuthorization(ruleTypes, operations, authorizationEntity) {
    const {
      authorizedRuleTypes
    } = await this.augmentRuleTypesWithAuthorization(ruleTypes, operations, authorizationEntity);
    return authorizedRuleTypes;
  }
  async augmentRuleTypesWithAuthorization(ruleTypes, operations, authorizationEntity, featuresIds) {
    const fIds = new Set(featuresIds !== null && featuresIds !== void 0 ? featuresIds : await this.featuresIds);

    /**
     * Temporary hack to fix issues with the discover consumer.
     * Issue: https://github.com/elastic/kibana/issues/184595.
     * PR https://github.com/elastic/kibana/pull/183756 will
     * remove the hack and fix it in a generic way.
     *
     * The discover consumer should be authorized
     * as the stackAlerts consumer.
     */
    if (fIds.has(DISCOVER_FEATURE_ID)) {
      fIds.delete(DISCOVER_FEATURE_ID);
      fIds.add(_ruleDataUtils.STACK_ALERTS_FEATURE_ID);
    }
    if (this.authorization && this.shouldCheckAuthorization()) {
      const checkPrivileges = this.authorization.checkPrivilegesDynamicallyWithRequest(this.request);

      // add an empty `authorizedConsumers` array on each ruleType
      const ruleTypesWithAuthorization = Array.from(this.augmentWithAuthorizedConsumers(ruleTypes, {}));
      const ruleTypesAuthorized = new Map();
      // map from privilege to ruleType which we can refer back to when analyzing the result
      // of checkPrivileges
      const privilegeToRuleType = new Map();
      const allPossibleConsumers = await this.allPossibleConsumers;
      const addLegacyConsumerPrivileges = legacyConsumer => legacyConsumer === _types.ALERTING_FEATURE_ID || legacyConsumer === DISCOVER_FEATURE_ID || (0, _lodash.isEmpty)(featuresIds);
      for (const feature of fIds) {
        const featureDef = this.features.getKibanaFeatures().find(kFeature => kFeature.id === feature);
        for (const ruleTypeId of (_featureDef$alerting = featureDef === null || featureDef === void 0 ? void 0 : featureDef.alerting) !== null && _featureDef$alerting !== void 0 ? _featureDef$alerting : []) {
          var _featureDef$alerting;
          const ruleTypeAuth = ruleTypesWithAuthorization.find(rtwa => rtwa.id === ruleTypeId);
          if (ruleTypeAuth) {
            if (!ruleTypesAuthorized.has(ruleTypeId)) {
              ruleTypesAuthorized.set(ruleTypeId, ruleTypeAuth);
            }
            for (const operation of operations) {
              privilegeToRuleType.set(this.authorization.actions.alerting.get(ruleTypeId, feature, authorizationEntity, operation), [ruleTypeAuth, feature, hasPrivilegeByOperation(operation), ruleTypeAuth.producer === feature]);
              // FUTURE ENGINEER
              // We are just trying to add back the legacy consumers associated
              // to the rule type to get back the privileges that was given at one point
              if (!(0, _lodash.isEmpty)(ruleTypeAuth.validLegacyConsumers)) {
                ruleTypeAuth.validLegacyConsumers.forEach(legacyConsumer => {
                  if (addLegacyConsumerPrivileges(legacyConsumer)) {
                    if (!allPossibleConsumers[legacyConsumer]) {
                      allPossibleConsumers[legacyConsumer] = {
                        read: true,
                        all: true
                      };
                    }
                    privilegeToRuleType.set(this.authorization.actions.alerting.get(ruleTypeId, legacyConsumer, authorizationEntity, operation), [ruleTypeAuth, legacyConsumer, hasPrivilegeByOperation(operation), false]);
                  }
                });
              }
            }
          }
        }
      }
      const {
        username,
        hasAllRequested,
        privileges
      } = await checkPrivileges({
        kibana: [...privilegeToRuleType.keys()]
      });
      return {
        username,
        hasAllRequested,
        authorizedRuleTypes: hasAllRequested && featuresIds === undefined ?
        // has access to all features
        this.augmentWithAuthorizedConsumers(new Set(ruleTypesAuthorized.values()), allPossibleConsumers) :
        // only has some of the required privileges
        privileges.kibana.reduce((authorizedRuleTypes, {
          authorized,
          privilege
        }) => {
          if (authorized && privilegeToRuleType.has(privilege)) {
            const [ruleType, feature, hasPrivileges, isAuthorizedAtProducerLevel] = privilegeToRuleType.get(privilege);
            if (fIds.has(feature)) {
              ruleType.authorizedConsumers[feature] = mergeHasPrivileges(hasPrivileges, ruleType.authorizedConsumers[feature]);
              if (isAuthorizedAtProducerLevel) {
                // granting privileges under the producer automatically authorized the Rules Management UI as well
                ruleType.validLegacyConsumers.forEach(legacyConsumer => {
                  if (addLegacyConsumerPrivileges(legacyConsumer)) {
                    ruleType.authorizedConsumers[legacyConsumer] = mergeHasPrivileges(hasPrivileges, ruleType.authorizedConsumers[legacyConsumer]);
                  }
                });
              }
              authorizedRuleTypes.add(ruleType);
            }
          }
          return authorizedRuleTypes;
        }, new Set())
      };
    } else {
      return {
        hasAllRequested: true,
        authorizedRuleTypes: this.augmentWithAuthorizedConsumers(new Set([...ruleTypes].filter(ruleType => fIds.has(ruleType.producer))), await this.allPossibleConsumers)
      };
    }
  }
  augmentWithAuthorizedConsumers(ruleTypes, authorizedConsumers) {
    return new Set(Array.from(ruleTypes).map(ruleType => ({
      ...ruleType,
      authorizedConsumers: {
        ...authorizedConsumers
      }
    })));
  }
}
exports.AlertingAuthorization = AlertingAuthorization;
function mergeHasPrivileges(left, right) {
  var _ref, _ref2;
  return {
    read: (_ref = left.read || (right === null || right === void 0 ? void 0 : right.read)) !== null && _ref !== void 0 ? _ref : false,
    all: (_ref2 = left.all || (right === null || right === void 0 ? void 0 : right.all)) !== null && _ref2 !== void 0 ? _ref2 : false
  };
}
function hasPrivilegeByOperation(operation) {
  const read = Object.values(ReadOperations).includes(operation);
  const all = Object.values(WriteOperations).includes(operation);
  return {
    read: read || all,
    all
  };
}
function asAuthorizedConsumers(consumers, hasPrivileges) {
  return consumers.reduce((acc, feature) => {
    acc[feature] = hasPrivileges;
    return acc;
  }, {});
}
function getUnauthorizedMessage(alertTypeId, scope, operation, entity) {
  return `Unauthorized by "${scope}" to ${operation} "${alertTypeId}" ${entity}`;
}
const getValidConsumer = ({
  validLegacyConsumers,
  legacyConsumer,
  producer
}) => legacyConsumer === _types.ALERTING_FEATURE_ID || validLegacyConsumers.includes(legacyConsumer) ? producer : legacyConsumer;
exports.getValidConsumer = getValidConsumer;