"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateRuleDataSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validation = require("../../../validation");
var _schemas = require("../../../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateRuleDataSchema = exports.updateRuleDataSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string({
      validate: _validation.validateDuration
    })
  }),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    validate: _validation.validateDuration
  }))),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()), {
    defaultValue: {}
  }),
  actions: _configSchema.schema.arrayOf(_schemas.actionRequestSchema, {
    defaultValue: []
  }),
  systemActions: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_schemas.systemActionRequestSchema, {
    defaultValue: []
  })),
  notifyWhen: _configSchema.schema.maybe(_configSchema.schema.nullable(_schemas.notifyWhenSchema)),
  alertDelay: _configSchema.schema.maybe(_schemas.alertDelaySchema),
  flapping: _configSchema.schema.maybe(_configSchema.schema.nullable(_schemas.flappingSchema))
}, {
  unknowns: 'allow'
});