"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTagsParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _latest = require("../../../../../../common/routes/rule/apis/tags/constants/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTagsParamsSchema = exports.ruleTagsParamsSchema = _configSchema.schema.object({
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: _latest.DEFAULT_TAGS_PER_PAGE,
    min: 1
  })),
  search: _configSchema.schema.maybe(_configSchema.schema.string())
});