"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findRulesParamsSchema = exports.findRulesOptionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findRulesOptionsSchema = exports.findRulesOptionsSchema = _configSchema.schema.object({
  perPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  page: _configSchema.schema.maybe(_configSchema.schema.number()),
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  defaultSearchOperator: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('AND'), _configSchema.schema.literal('OR')])),
  searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  hasReference: _configSchema.schema.maybe(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    id: _configSchema.schema.string()
  })),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  filter: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())])),
  filterConsumers: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}, {
  unknowns: 'allow'
});
const findRulesParamsSchema = exports.findRulesParamsSchema = _configSchema.schema.object({
  options: _configSchema.schema.maybe(findRulesOptionsSchema),
  excludeFromPublicApi: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  includeSnoozeData: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  featureIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});