"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindows = findMaintenanceWindows;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _transforms = require("../../transforms");
var _maintenance_window = require("../../../../data/maintenance_window");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findMaintenanceWindows(context, params) {
  const {
    savedObjectsClient,
    logger
  } = context;
  try {
    if (params) {
      _schemas.findMaintenanceWindowsParamsSchema.validate(params);
    }
  } catch (error) {
    throw _boom.default.badRequest(`Error validating find maintenance windows data - ${error.message}`);
  }
  try {
    const result = await (0, _maintenance_window.findMaintenanceWindowSo)({
      savedObjectsClient,
      ...(params ? {
        savedObjectsFindOptions: {
          page: params.page,
          perPage: params.perPage
        }
      } : {})
    });
    return {
      page: result.page,
      perPage: result.per_page,
      total: result.total,
      data: result.saved_objects.map(so => (0, _transforms.transformMaintenanceWindowAttributesToMaintenanceWindow)({
        attributes: so.attributes,
        id: so.id
      }))
    };
  } catch (e) {
    const errorMessage = `Failed to find maintenance window, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}