"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.archiveMaintenanceWindow = archiveMaintenanceWindow;
var _moment = _interopRequireDefault(require("moment"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _schemas = require("./schemas");
var _generate_maintenance_window_events = require("../../lib/generate_maintenance_window_events");
var _retry_if_conflicts = require("../../../../lib/retry_if_conflicts");
var _transforms = require("../../transforms");
var _maintenance_window = require("../../../../data/maintenance_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getArchivedExpirationDate = shouldArchive => {
  if (shouldArchive) {
    return new Date().toISOString();
  }
  return _moment.default.utc().add(1, 'year').toISOString();
};
async function archiveMaintenanceWindow(context, params) {
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `maintenanceWindowClient.archive('${params.id})`, async () => {
    return await archiveWithOCC(context, params);
  });
}
async function archiveWithOCC(context, params) {
  try {
    _schemas.archiveMaintenanceWindowParamsSchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating archive params - ${error.message}`);
  }
  const {
    savedObjectsClient,
    getModificationMetadata,
    logger
  } = context;
  const {
    id,
    archive: shouldArchive
  } = params;
  const modificationMetadata = await getModificationMetadata();
  const expirationDate = getArchivedExpirationDate(shouldArchive);
  try {
    const {
      attributes,
      version
    } = await (0, _maintenance_window.getMaintenanceWindowSo)({
      id,
      savedObjectsClient
    });
    const events = (0, _generate_maintenance_window_events.mergeEvents)({
      newEvents: (0, _generate_maintenance_window_events.generateMaintenanceWindowEvents)({
        // @ts-expect-error upgrade typescript v5.1.6
        rRule: attributes.rRule,
        duration: attributes.duration,
        expirationDate
      }),
      oldEvents: attributes.events
    });
    const updatedMaintenanceWindowAttributes = (0, _transforms.transformMaintenanceWindowToMaintenanceWindowAttributes)({
      ...attributes,
      events,
      expirationDate,
      updatedAt: modificationMetadata.updatedAt,
      updatedBy: modificationMetadata.updatedBy
    });
    const result = await (0, _maintenance_window.updateMaintenanceWindowSo)({
      id,
      savedObjectsClient,
      updateMaintenanceWindowAttributes: updatedMaintenanceWindowAttributes,
      savedObjectsUpdateOptions: {
        version
      }
    });
    return (0, _transforms.transformMaintenanceWindowAttributesToMaintenanceWindow)({
      attributes: {
        ...attributes,
        ...result.attributes
      },
      id: result.id
    });
  } catch (e) {
    const errorMessage = `Failed to archive maintenance window by id: ${id}, Error: ${e}`;
    logger.error(errorMessage);
    throw _boom.default.boomify(e, {
      message: errorMessage
    });
  }
}