"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MaintenanceWindowsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana_react = require("../../utils/kibana_react");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _empty_prompt = require("./components/empty_prompt");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_navigation = require("../../hooks/use_navigation");
var _maintenance_windows_list = require("./components/maintenance_windows_list");
var _use_find_maintenance_windows = require("../../hooks/use_find_maintenance_windows");
var _center_justified_spinner = require("./components/center_justified_spinner");
var _page_header = require("./components/page_header");
var _use_license = require("../../hooks/use_license");
var _license_prompt = require("./components/license_prompt");
var _common = require("../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaintenanceWindowsPage = exports.default = exports.MaintenanceWindowsPage = /*#__PURE__*/_react.default.memo(() => {
  const {
    application: {
      capabilities
    },
    chrome,
    docLinks
  } = (0, _kibana_react.useKibana)().services;
  const {
    isAtLeastPlatinum
  } = (0, _use_license.useLicense)();
  const hasLicense = isAtLeastPlatinum();
  const {
    navigateToCreateMaintenanceWindow
  } = (0, _use_navigation.useCreateMaintenanceWindowNavigation)();
  const {
    isLoading,
    isInitialLoading,
    maintenanceWindows,
    refetch
  } = (0, _use_find_maintenance_windows.useFindMaintenanceWindows)({
    enabled: hasLicense
  });
  (0, _use_breadcrumbs.useBreadcrumbs)(_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindows);
  const handleClickCreate = (0, _react.useCallback)(() => {
    navigateToCreateMaintenanceWindow();
  }, [navigateToCreateMaintenanceWindow]);
  const refreshData = (0, _react.useCallback)(() => refetch(), [refetch]);
  const showWindowMaintenance = capabilities[_common.MAINTENANCE_WINDOW_FEATURE_ID].show;
  const writeWindowMaintenance = capabilities[_common.MAINTENANCE_WINDOW_FEATURE_ID].save;
  const showEmptyPrompt = !isLoading && maintenanceWindows.length === 0 && showWindowMaintenance && writeWindowMaintenance;
  const readOnly = showWindowMaintenance && !writeWindowMaintenance;

  // if the user is read only then display the glasses badge in the global navigation header
  const setBadge = (0, _react.useCallback)(() => {
    if (readOnly) {
      chrome.setBadge({
        text: i18n.READ_ONLY_BADGE_TEXT,
        tooltip: i18n.READ_ONLY_BADGE_TOOLTIP,
        iconType: 'glasses'
      });
    }
  }, [chrome, readOnly]);
  (0, _react.useEffect)(() => {
    setBadge();

    // remove the icon after the component unmounts
    return () => {
      chrome.setBadge();
    };
  }, [setBadge, chrome]);
  if (isInitialLoading) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    alignItems: "top"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, i18n.MAINTENANCE_WINDOWS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_page_header.ExperimentalBadge, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.MAINTENANCE_WINDOWS_DESCRIPTION))), !showEmptyPrompt && hasLicense && writeWindowMaintenance ? /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mw-create-button",
    onClick: handleClickCreate,
    iconType: "plusInCircle",
    fill: true
  }, i18n.CREATE_NEW_BUTTON)) : null), !hasLicense ? /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, null) : showEmptyPrompt ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    onClickCreate: handleClickCreate,
    docLinks: docLinks.links
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_maintenance_windows_list.MaintenanceWindowsList, {
    readOnly: readOnly,
    refreshData: refreshData,
    isLoading: isLoading,
    items: maintenanceWindows
  })));
});
MaintenanceWindowsPage.displayName = 'MaintenanceWindowsPage';
// eslint-disable-next-line import/no-default-export