"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rRuleResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rRuleResponseSchema = exports.rRuleResponseSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string({
    meta: {
      description: 'Rule start date in Coordinated Universal Time (UTC).'
    }
  }),
  tzid: _configSchema.schema.string({
    meta: {
      description: 'Indicates timezone abbreviation.'
    }
  }),
  freq: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6)], {
    meta: {
      description: 'Indicates frequency of the rule. Options are YEARLY, MONTHLY, WEEKLY, DAILY.'
    }
  })),
  until: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Recur the rule until this date.'
    }
  })),
  count: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'Number of times the rule should recur until it stops.'
    }
  })),
  interval: _configSchema.schema.maybe(_configSchema.schema.number({
    meta: {
      description: 'Indicates the interval of frequency. For example, 1 and YEARLY is every 1 year, 2 and WEEKLY is every 2 weeks.'
    }
  })),
  wkst: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('MO'), _configSchema.schema.literal('TU'), _configSchema.schema.literal('WE'), _configSchema.schema.literal('TH'), _configSchema.schema.literal('FR'), _configSchema.schema.literal('SA'), _configSchema.schema.literal('SU')], {
    meta: {
      description: 'Indicates the start of week, defaults to Monday.'
    }
  })),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()], {
    meta: {
      description: 'Indicates the days of the week to recur or else nth-day-of-month strings. For example, "+2TU" second Tuesday of month, "-1FR" last Friday of the month, which are internally converted to a `byweekday/bysetpos` combination.'
    }
  }))),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'Indicates months of the year that this rule should recur.'
    }
  }))),
  bysetpos: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'A positive or negative integer affecting the nth day of the month. For example, -2 combined with `byweekday` of FR is 2nd to last Friday of the month. It is recommended to not set this manually and just use `byweekday`.'
    }
  }))),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'Indicates the days of the month to recur.'
    }
  }))),
  byyearday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'Indicates the days of the year that this rule should recur.'
    }
  }))),
  byweekno: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'Indicates number of the week hours to recur.'
    }
  }))),
  byhour: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'Indicates hours of the day to recur.'
    }
  }))),
  byminute: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'Indicates minutes of the hour to recur.'
    }
  }))),
  bysecond: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'Indicates seconds of the day to recur.'
    }
  })))
});