"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindowsResponseBodySchema = exports.findMaintenanceWindowsRequestQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _response = require("../../../response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_DOCS = 10000;
const findMaintenanceWindowsRequestQuerySchema = exports.findMaintenanceWindowsRequestQuerySchema = _configSchema.schema.object({
  // we do not need to use schema.maybe here, because if we do not pass property page, defaultValue will be used
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1,
    max: MAX_DOCS,
    meta: {
      description: 'The page number to return.'
    }
  }),
  // we do not need to use schema.maybe here, because if we do not pass property per_page, defaultValue will be used
  per_page: _configSchema.schema.number({
    defaultValue: 1000,
    min: 0,
    max: 100,
    meta: {
      description: 'The number of maintenance windows to return per page.'
    }
  })
}, {
  validate: params => {
    var _params$page, _params$per_page;
    const pageAsNumber = (_params$page = params.page) !== null && _params$page !== void 0 ? _params$page : 0;
    const perPageAsNumber = (_params$per_page = params.per_page) !== null && _params$per_page !== void 0 ? _params$per_page : 0;
    if (Math.max(pageAsNumber, pageAsNumber * perPageAsNumber) > MAX_DOCS) {
      return `The number of documents is too high. Paginating through more than ${MAX_DOCS} documents is not possible.`;
    }
  }
});
const findMaintenanceWindowsResponseBodySchema = exports.findMaintenanceWindowsResponseBodySchema = _configSchema.schema.object({
  page: _configSchema.schema.number(),
  per_page: _configSchema.schema.number(),
  total: _configSchema.schema.number(),
  data: _configSchema.schema.arrayOf(_response.maintenanceWindowResponseSchemaV1)
});