"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusSchema = exports.errorResponseSchema = exports.backfillResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusSchema = exports.statusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.adHocRunStatus.COMPLETE), _configSchema.schema.literal(_constants.adHocRunStatus.PENDING), _configSchema.schema.literal(_constants.adHocRunStatus.RUNNING), _configSchema.schema.literal(_constants.adHocRunStatus.ERROR), _configSchema.schema.literal(_constants.adHocRunStatus.TIMEOUT)]);
const backfillResponseSchema = exports.backfillResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  created_at: _configSchema.schema.string(),
  duration: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  rule: _configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    rule_type_id: _configSchema.schema.string(),
    params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any())),
    api_key_owner: _configSchema.schema.nullable(_configSchema.schema.string()),
    api_key_created_by_user: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
    consumer: _configSchema.schema.string(),
    enabled: _configSchema.schema.boolean(),
    schedule: _configSchema.schema.object({
      interval: _configSchema.schema.string()
    }),
    created_by: _configSchema.schema.nullable(_configSchema.schema.string()),
    updated_by: _configSchema.schema.nullable(_configSchema.schema.string()),
    created_at: _configSchema.schema.string(),
    updated_at: _configSchema.schema.string(),
    revision: _configSchema.schema.number()
  }),
  space_id: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  status: statusSchema,
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  schedule: _configSchema.schema.arrayOf(_configSchema.schema.object({
    run_at: _configSchema.schema.string(),
    status: statusSchema,
    interval: _configSchema.schema.string()
  }))
});
const errorResponseSchema = exports.errorResponseSchema = _configSchema.schema.object({
  error: _configSchema.schema.object({
    message: _configSchema.schema.string(),
    status: _configSchema.schema.maybe(_configSchema.schema.number()),
    rule: _configSchema.schema.object({
      id: _configSchema.schema.string(),
      name: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  })
});