"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleResponseSchema = exports.scheduleBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _ = require("../../../../..");
var _constants = require("../../../../../constants");
var _response = require("../../../response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleBodySchema = exports.scheduleBodySchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  rule_id: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  end: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  validate({
    start,
    end
  }) {
    return (0, _.validateBackfillSchedule)(start, end);
  }
}), {
  minSize: 1,
  maxSize: _constants.MAX_SCHEDULE_BACKFILL_BULK_SIZE
});
const scheduleResponseSchema = exports.scheduleResponseSchema = _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_response.backfillResponseSchemaV1, _response.errorResponseSchemaV1]));