"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_CHANGE_POINT_IN_ML_APP_ACTION = void 0;
exports.createOpenChangePointInMlAppAction = createOpenChangePointInMlAppAction;
exports.getEmbeddableTimeRange = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _change_point_action_context = require("./change_point_action_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_CHANGE_POINT_IN_ML_APP_ACTION = exports.OPEN_CHANGE_POINT_IN_ML_APP_ACTION = 'openChangePointInMlAppAction';
const getEmbeddableTimeRange = embeddable => {
  var _embeddable$timeRange;
  let timeRange = (_embeddable$timeRange = embeddable.timeRange$) === null || _embeddable$timeRange === void 0 ? void 0 : _embeddable$timeRange.getValue();
  if (!timeRange && (0, _presentationPublishing.apiHasParentApi)(embeddable) && (0, _presentationPublishing.apiPublishesTimeRange)(embeddable.parentApi)) {
    timeRange = embeddable.parentApi.timeRange$.getValue();
  }
  return timeRange;
};
exports.getEmbeddableTimeRange = getEmbeddableTimeRange;
function createOpenChangePointInMlAppAction(coreStart, pluginStart) {
  return {
    id: 'open-change-point-in-ml-app',
    type: OPEN_CHANGE_POINT_IN_ML_APP_ACTION,
    getIconType(context) {
      return 'link';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.actions.openChangePointInMlAppName', {
      defaultMessage: 'Open in AIOps Labs'
    }),
    async getHref(context) {
      if (!(0, _change_point_action_context.isChangePointChartEmbeddableContext)(context)) {
        throw new _public.IncompatibleActionError();
      }
      const locator = pluginStart.share.url.locators.get('ML_APP_LOCATOR');
      const {
        metricField,
        fn,
        splitField,
        dataViewId
      } = context.embeddable;
      return locator.getUrl({
        page: 'aiops/change_point_detection',
        pageState: {
          index: dataViewId.getValue(),
          timeRange: getEmbeddableTimeRange(context.embeddable),
          fieldConfigs: [{
            fn: fn.getValue(),
            metricField: metricField.getValue(),
            ...(splitField.getValue() ? {
              splitField: splitField.getValue()
            } : {})
          }]
        }
      });
    },
    async execute(context) {
      if (!(0, _change_point_action_context.isChangePointChartEmbeddableContext)(context)) {
        throw new _public.IncompatibleActionError();
      }
      const aiopsChangePointUrl = await this.getHref(context);
      if (aiopsChangePointUrl) {
        await coreStart.application.navigateToUrl(aiopsChangePointUrl);
      }
    },
    async isCompatible(context) {
      return (0, _change_point_action_context.isChangePointChartEmbeddableContext)(context);
    }
  };
}