"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddChangePointChartAction = createAddChangePointChartAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("@kbn/aiops-change-point-detection/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
function createAddChangePointChartAction(coreStart, pluginStart) {
  return {
    id: 'create-change-point-chart',
    grouping: [{
      id: 'ml',
      getDisplayName: () => _i18n.i18n.translate('xpack.aiops.navMenu.mlAppNameText', {
        defaultMessage: 'Machine Learning and Analytics'
      }),
      getIconType: () => 'machineLearningApp'
    }],
    order: 10,
    getIconType: () => 'changePointDetection',
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.embeddableChangePointChartDisplayName', {
      defaultMessage: 'Change point detection'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      try {
        const {
          resolveEmbeddableChangePointUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/change_point_chart/resolve_change_point_config_input')));
        const initialState = await resolveEmbeddableChangePointUserInput(coreStart, pluginStart, context.embeddable, context.embeddable.uuid);
        presentationContainerParent.addNewPanel({
          panelType: _constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE,
          initialState
        });
      } catch (e) {
        return Promise.reject();
      }
    }
  };
}