"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiopsPlugin = void 0;
var _rxjs = require("rxjs");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _shared_components = require("./shared_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AiopsPlugin {
  setup(core, {
    embeddable,
    cases,
    licensing,
    uiActions
  }) {
    Promise.all([(0, _rxjs.firstValueFrom)(licensing.license$), Promise.resolve().then(() => _interopRequireWildcard(require('./embeddables'))), Promise.resolve().then(() => _interopRequireWildcard(require('./ui_actions'))), Promise.resolve().then(() => _interopRequireWildcard(require('./cases/register_change_point_charts_attachment'))), core.getStartServices()]).then(([license, {
      registerEmbeddables
    }, {
      registerAiopsUiActions
    }, {
      registerChangePointChartsAttachment
    }, [coreStart, pluginStart]]) => {
      const {
        canUseAiops
      } = coreStart.application.capabilities.ml;
      if (license.hasAtLeast('platinum') && canUseAiops) {
        if (embeddable) {
          registerEmbeddables(embeddable, core);
        }
        if (uiActions) {
          registerAiopsUiActions(uiActions, coreStart, pluginStart);
        }
        if (cases) {
          registerChangePointChartsAttachment(cases, coreStart, pluginStart);
        }
      }
    });
  }
  start(core, plugins) {
    return {
      ChangePointDetectionComponent: (0, _shared_components.getChangePointDetectionComponent)(core, plugins),
      getPatternAnalysisAvailable: async () => {
        const {
          getPatternAnalysisAvailable
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_categorization/log_categorization_enabled')));
        return getPatternAnalysisAvailable(plugins.licensing);
      },
      PatternAnalysisComponent: (0, _sharedUxUtility.dynamic)(async () => Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_categorization/log_categorization_for_embeddable/log_categorization_for_discover_wrapper'))))
    };
  }
  stop() {}
}
exports.AiopsPlugin = AiopsPlugin;