"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializePatternAnalysisControls = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializePatternAnalysisControls = rawState => {
  const dataViewId = new _rxjs.BehaviorSubject(rawState.dataViewId);
  const fieldName = new _rxjs.BehaviorSubject(rawState.fieldName);
  const minimumTimeRangeOption = new _rxjs.BehaviorSubject(rawState.minimumTimeRangeOption);
  const randomSamplerMode = new _rxjs.BehaviorSubject(rawState.randomSamplerMode);
  const randomSamplerProbability = new _rxjs.BehaviorSubject(rawState.randomSamplerProbability);
  const updateUserInput = update => {
    dataViewId.next(update.dataViewId);
    fieldName.next(update.fieldName);
    minimumTimeRangeOption.next(update.minimumTimeRangeOption);
    randomSamplerMode.next(update.randomSamplerMode);
    randomSamplerProbability.next(update.randomSamplerProbability);
  };
  const serializePatternAnalysisChartState = () => {
    return {
      dataViewId: dataViewId.getValue(),
      fieldName: fieldName.getValue(),
      minimumTimeRangeOption: minimumTimeRangeOption.getValue(),
      randomSamplerMode: randomSamplerMode.getValue(),
      randomSamplerProbability: randomSamplerProbability.getValue()
    };
  };
  const patternAnalysisControlsComparators = {
    dataViewId: [dataViewId, arg => dataViewId.next(arg)],
    fieldName: [fieldName, arg => fieldName.next(arg)],
    minimumTimeRangeOption: [minimumTimeRangeOption, arg => minimumTimeRangeOption.next(arg)],
    randomSamplerMode: [randomSamplerMode, arg => randomSamplerMode.next(arg)],
    randomSamplerProbability: [randomSamplerProbability, arg => randomSamplerProbability.next(arg)]
  };
  return {
    patternAnalysisControlsApi: {
      dataViewId,
      fieldName,
      minimumTimeRangeOption,
      randomSamplerMode,
      randomSamplerProbability,
      updateUserInput
    },
    serializePatternAnalysisChartState,
    patternAnalysisControlsComparators
  };
};
exports.initializePatternAnalysisControls = initializePatternAnalysisControls;