"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _aiopsComponents = require("@kbn/aiops-components");
var _client = require("@kbn/ml-response-stream/client");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _constants = require("@kbn/aiops-common/constants");
var _stream_reducer = require("@kbn/aiops-log-rate-analysis/api/stream_reducer");
var _log_rate_analysis_field_candidates_slice = require("@kbn/aiops-log-rate-analysis/state/log_rate_analysis_field_candidates_slice");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _use_columns = require("../log_rate_analysis_results_table/use_columns");
var _storage = require("../../types/storage");
var _log_rate_analysis_results_table = require("../log_rate_analysis_results_table");
var _item_filter_popover = require("./item_filter_popover");
var _log_rate_analysis_info_popover = require("./log_rate_analysis_info_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupResultsMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResults', {
  defaultMessage: 'Smart grouping'
});
const groupResultsHelpMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsHelpMessage', {
  defaultMessage: 'Items which are unique to a group are marked by an asterisk (*).'
});
const groupResultsOffMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsOff', {
  defaultMessage: 'Off'
});
const groupResultsOnMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.groupedSwitchLabel.groupResultsOn', {
  defaultMessage: 'On'
});
const resultsGroupedOffId = 'aiopsLogRateAnalysisGroupingOff';
const resultsGroupedOnId = 'aiopsLogRateAnalysisGroupingOn';
const fieldFilterHelpText = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.fieldFilterHelpText', {
  defaultMessage: 'Deselect non-relevant fields to remove them from the analysis and click the Apply button to rerun the analysis.  Use the search bar to filter the list, then select/deselect multiple fields with the actions below.'
});
const columnsFilterHelpText = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.columnsFilterHelpText', {
  defaultMessage: 'Configure visible columns.'
});
const disabledFieldFilterApplyButtonTooltipContent = _i18n.i18n.translate('xpack.aiops.analysis.fieldSelectorNotEnoughFieldsSelected', {
  defaultMessage: 'Grouping requires at least 2 fields to be selected.'
});
const disabledColumnFilterApplyButtonTooltipContent = _i18n.i18n.translate('xpack.aiops.analysis.columnSelectorNotEnoughColumnsSelected', {
  defaultMessage: 'At least one column must be selected.'
});
const columnSearchAriaLabel = _i18n.i18n.translate('xpack.aiops.analysis.columnSelectorAriaLabel', {
  defaultMessage: 'Filter columns'
});
const columnsButton = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.page.columnsFilterButtonLabel', {
  defaultMessage: 'Columns'
});
const fieldsButton = _i18n.i18n.translate('xpack.aiops.analysis.fieldsButtonLabel', {
  defaultMessage: 'Fields'
});

/**
 * Interface for log rate analysis results data.
 */

/**
 * LogRateAnalysis props require a data view.
 */

const LogRateAnalysisResults = ({
  onReset,
  searchQuery,
  barColorOverride,
  barHighlightColorOverride
}) => {
  var _data$loadingState;
  const {
    analytics,
    http,
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const dispatch = (0, _state.useAppDispatch)();
  const {
    analysisType,
    earliest,
    latest,
    chartWindowParameters,
    documentStats: {
      sampleProbability
    },
    stickyHistogram,
    isBrushCleared
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const {
    isRunning,
    errors: streamErrors
  } = (0, _state.useAppSelector)(s => s.logRateAnalysisStream);
  const data = (0, _state.useAppSelector)(s => s.logRateAnalysisResults);
  const fieldCandidates = (0, _state.useAppSelector)(s => s.logRateAnalysisFieldCandidates);
  const {
    currentAnalysisWindowParameters
  } = data;

  // Store the performance metric's start time using a ref
  // to be able to track it across rerenders.
  const analysisStartTime = (0, _react.useRef)(window.performance.now());
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const [groupResults, setGroupResults] = (0, _react.useState)(false);
  const [overrides, setOverrides] = (0, _react.useState)(undefined);
  const [shouldStart, setShouldStart] = (0, _react.useState)(false);
  const [toggleIdSelected, setToggleIdSelected] = (0, _react.useState)(resultsGroupedOffId);
  const [skippedColumns, setSkippedColumns] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_LOG_RATE_ANALYSIS_RESULT_COLUMNS, ['p-value', 'Baseline rate', 'Deviation rate']);
  // null is used as the uninitialized state to identify the first load.
  const [skippedFields, setSkippedFields] = (0, _react.useState)(null);
  const onGroupResultsToggle = optionId => {
    setToggleIdSelected(optionId);
    setGroupResults(optionId === resultsGroupedOnId);

    // When toggling the group switch, clear all row selections
    dispatch((0, _state.clearAllRowState)());
  };
  const {
    fieldFilterUniqueItems,
    fieldFilterSkippedItems,
    keywordFieldCandidates,
    textFieldCandidates
  } = fieldCandidates;
  const fieldFilterButtonDisabled = isRunning || fieldCandidates.isLoading || fieldFilterUniqueItems.length === 0;

  // Set skipped fields only on first load, otherwise we'd overwrite the user's selection.
  (0, _react.useEffect)(() => {
    if (skippedFields === null && fieldFilterSkippedItems.length > 0) setSkippedFields(fieldFilterSkippedItems);
  }, [fieldFilterSkippedItems, skippedFields]);
  const onFieldsFilterChange = skippedFieldsUpdate => {
    dispatch((0, _stream_reducer.resetResults)());
    setSkippedFields(skippedFieldsUpdate);
    setOverrides({
      loaded: 0,
      remainingKeywordFieldCandidates: keywordFieldCandidates.filter(d => !skippedFieldsUpdate.includes(d)),
      remainingTextFieldCandidates: textFieldCandidates.filter(d => !skippedFieldsUpdate.includes(d)),
      regroupOnly: false
    });
    startHandler(true, false);
  };
  const onVisibleColumnsChange = columns => {
    setSkippedColumns(columns);
  };
  function cancelHandler() {
    abortCtrl.current.abort();
    dispatch((0, _client.cancelStream)());
  }
  (0, _react.useEffect)(() => {
    if (!isRunning) {
      const {
        loaded,
        remainingKeywordFieldCandidates,
        remainingTextFieldCandidates,
        groupsMissing
      } = data;
      if (loaded < 1 && (Array.isArray(remainingKeywordFieldCandidates) && remainingKeywordFieldCandidates.length > 0 || Array.isArray(remainingTextFieldCandidates) && remainingTextFieldCandidates.length > 0 || groupsMissing)) {
        setOverrides({
          loaded,
          remainingKeywordFieldCandidates,
          remainingTextFieldCandidates,
          significantItems: data.significantItems
        });
      } else if (loaded > 0) {
        // Reset all overrides.
        setOverrides(undefined);

        // Track performance metric
        if (analysisStartTime.current !== undefined) {
          const analysisDuration = window.performance.now() - analysisStartTime.current;

          // Set this to undefined so reporting the metric gets triggered only once.
          analysisStartTime.current = undefined;
          (0, _ebtTools.reportPerformanceMetricEvent)(analytics, {
            eventName: 'aiopsLogRateAnalysisCompleted',
            duration: analysisDuration
          });
        }
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isRunning]);
  const errors = (0, _react.useMemo)(() => [...streamErrors, ...data.errors], [streamErrors, data.errors]);

  // Start handler clears possibly hovered or pinned
  // significant items on analysis refresh.
  function startHandler(continueAnalysis = false, resetGroupButton = true) {
    if (!continueAnalysis) {
      dispatch((0, _stream_reducer.resetResults)());
      setOverrides({
        remainingKeywordFieldCandidates: keywordFieldCandidates.filter(d => skippedFields === null || !skippedFields.includes(d)),
        remainingTextFieldCandidates: textFieldCandidates.filter(d => skippedFields === null || !skippedFields.includes(d))
      });
    }

    // Reset grouping to false and clear all row selections when restarting the analysis.
    if (resetGroupButton) {
      setGroupResults(false);
      setToggleIdSelected(resultsGroupedOffId);
      dispatch((0, _state.clearAllRowState)());
    }
    dispatch((0, _stream_reducer.setCurrentAnalysisType)(analysisType));
    dispatch((0, _stream_reducer.setCurrentAnalysisWindowParameters)(chartWindowParameters));

    // We trigger hooks updates above so we cannot directly call `start()` here
    // because it would be run with stale arguments.
    setShouldStart(true);
  }
  const startParams = (0, _react.useMemo)(() => {
    var _dataView$timeFieldNa;
    if (!chartWindowParameters || !earliest || !latest) {
      return undefined;
    }
    return {
      http,
      endpoint: '/internal/aiops/log_rate_analysis',
      apiVersion: '3',
      abortCtrl,
      body: {
        start: earliest,
        end: latest,
        searchQuery: JSON.stringify(searchQuery),
        // TODO Handle data view without time fields.
        timeFieldName: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : '',
        index: dataView.getIndexPattern(),
        grouping: true,
        flushFix: true,
        // If analysis type is `spike`, pass on window parameters as is,
        // if it's `dip`, swap baseline and deviation.
        ...(analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE ? chartWindowParameters : (0, _aiopsLogRateAnalysis.getSwappedWindowParameters)(chartWindowParameters)),
        overrides,
        sampleProbability
      },
      headers: {
        [_constants.AIOPS_ANALYSIS_RUN_ORIGIN]: embeddingOrigin
      }
    };
  }, [analysisType, earliest, latest, http, searchQuery, dataView, chartWindowParameters, sampleProbability, overrides, embeddingOrigin]);
  (0, _react.useEffect)(() => {
    if (shouldStart && startParams) {
      dispatch((0, _client.startStream)(startParams));
      setShouldStart(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [shouldStart]);
  (0, _react.useEffect)(() => {
    if (startParams) {
      dispatch((0, _log_rate_analysis_field_candidates_slice.fetchFieldCandidates)(startParams));
      dispatch((0, _stream_reducer.setCurrentAnalysisType)(analysisType));
      dispatch((0, _stream_reducer.setCurrentAnalysisWindowParameters)(chartWindowParameters));
      dispatch((0, _client.startStream)(startParams));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const groupTableItems = (0, _react.useMemo)(() => (0, _log_rate_analysis_results_table.getGroupTableItems)(data.significantItemsGroups), [data.significantItemsGroups]);
  const shouldRerunAnalysis = (0, _react.useMemo)(() => currentAnalysisWindowParameters !== undefined && !(0, _lodash.isEqual)(currentAnalysisWindowParameters, chartWindowParameters), [currentAnalysisWindowParameters, chartWindowParameters]);
  const showLogRateAnalysisResultsTable = (data === null || data === void 0 ? void 0 : data.significantItems.length) > 0;
  const groupItemCount = groupTableItems.reduce((p, c) => {
    return p + c.groupItemsSortedByUniqueness.length;
  }, 0);
  const foundGroups = groupTableItems.length > 0 && groupItemCount > 0;

  // Disable the grouping switch toggle only if no groups were found,
  // the toggle wasn't enabled already and no fields were selected to be skipped.
  const disabledGroupResultsSwitch = !foundGroups && !groupResults;
  const toggleButtons = [{
    id: resultsGroupedOffId,
    label: groupResultsOffMessage,
    'data-test-subj': 'aiopsLogRateAnalysisGroupSwitchOff'
  }, {
    id: resultsGroupedOnId,
    label: groupResultsOnMessage,
    'data-test-subj': 'aiopsLogRateAnalysisGroupSwitchOn'
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aiopsLogRateAnalysisResults"
  }, /*#__PURE__*/_react.default.createElement(_aiopsComponents.ProgressControls, {
    isBrushCleared: isBrushCleared,
    progress: data.loaded,
    progressMessage: (_data$loadingState = data.loadingState) !== null && _data$loadingState !== void 0 ? _data$loadingState : '',
    isRunning: isRunning,
    onRefresh: () => startHandler(false),
    onCancel: cancelHandler,
    onReset: onReset,
    shouldRerunAnalysis: shouldRerunAnalysis,
    analysisInfo: /*#__PURE__*/_react.default.createElement(_log_rate_analysis_info_popover.LogRateAnalysisInfoPopover, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, groupResultsMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": `aiopsLogRateAnalysisGroupSwitch${groupResults ? ' checked' : ''}`,
    buttonSize: "s",
    isDisabled: disabledGroupResultsSwitch,
    legend: "Smart grouping",
    options: toggleButtons,
    idSelected: toggleIdSelected,
    onChange: onGroupResultsToggle
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_item_filter_popover.ItemFilterPopover, {
    dataTestSubj: "aiopsFieldFilterButton",
    disabled: fieldFilterButtonDisabled,
    disabledApplyButton: fieldFilterButtonDisabled,
    disabledApplyTooltipContent: disabledFieldFilterApplyButtonTooltipContent,
    helpText: fieldFilterHelpText,
    itemSearchAriaLabel: fieldsButton,
    popoverButtonTitle: fieldsButton,
    selectedItemLimit: 1,
    uniqueItemNames: fieldFilterUniqueItems,
    initialSkippedItems: fieldFilterSkippedItems,
    onChange: onFieldsFilterChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_item_filter_popover.ItemFilterPopover, {
    dataTestSubj: "aiopsColumnFilterButton",
    disabled: isRunning,
    disabledApplyButton: isRunning,
    disabledApplyTooltipContent: disabledColumnFilterApplyButtonTooltipContent,
    helpText: columnsFilterHelpText,
    itemSearchAriaLabel: columnSearchAriaLabel,
    initialSkippedItems: skippedColumns,
    popoverButtonTitle: columnsButton,
    selectedItemLimit: 1,
    uniqueItemNames: groupResults ? Object.values(_use_columns.commonColumns) : Object.values(_use_columns.significantItemColumns),
    onChange: onVisibleColumnsChange
  }))), errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.aiops.analysis.errorCallOutTitle', {
      defaultMessage: 'The following {errorCount, plural, one {error} other {errors}} occurred running the analysis.',
      values: {
        errorCount: errors.length
      }
    }),
    color: "warning",
    iconType: "warning",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, errors.length === 1 ? /*#__PURE__*/_react.default.createElement("p", null, errors[0]) : /*#__PURE__*/_react.default.createElement("ul", null, errors.map((e, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i
  }, e))), overrides !== undefined ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "aiopsLogRateAnalysisResultsTryToContinueAnalysisButton",
    size: "s",
    onClick: () => startHandler(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logRateAnalysis.page.tryToContinueAnalysisButtonText",
    defaultMessage: "Try to continue analysis"
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })) : null, showLogRateAnalysisResultsTable && groupResults && foundGroups && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, groupResults ? groupResultsHelpMessage : undefined)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !isRunning && !showLogRateAnalysisResultsTable && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "aiopsNoResultsFoundEmptyPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noResultsPromptTitle",
      defaultMessage: "The analysis did not return any results."
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noResultsPromptBody",
      defaultMessage: "Try to adjust the baseline and deviation time ranges and rerun the analysis. If you still get no results, there might be no statistically significant entities contributing to this deviation in log rate."
    }))
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: stickyHistogram ? {
      height: '500px',
      overflowX: 'hidden',
      overflowY: 'auto',
      paddingTop: '20px'
    } : undefined
  }, showLogRateAnalysisResultsTable && groupResults ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table.LogRateAnalysisResultsGroupsTable, {
    skippedColumns: skippedColumns,
    significantItems: data.significantItems,
    groupTableItems: groupTableItems,
    searchQuery: searchQuery,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride
  }) : null, showLogRateAnalysisResultsTable && !groupResults ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results_table.LogRateAnalysisResultsTable, {
    skippedColumns: skippedColumns,
    searchQuery: searchQuery,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride
  }) : null));
};
exports.LogRateAnalysisResults = LogRateAnalysisResults;