"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalCountHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Consolidate with duplicate component `TotalCountHeader` in
// `x-pack/plugins/data_visualizer/public/application/common/components/document_count_content/total_count_header.tsx`

const TotalCountHeader = ({
  sampleProbability,
  totalCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "aiopsTotalDocCountHeader"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.aiops.searchPanel.totalDocCountLabel",
  defaultMessage: "Total documents: {strongTotalCount}",
  values: {
    strongTotalCount: /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "aiopsTotalDocCount"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.searchPanel.totalDocCountNumber",
      defaultMessage: "{totalCount, plural, one {#} other {#}}",
      values: {
        totalCount
      }
    }))
  }
}), sampleProbability !== undefined && sampleProbability < 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.aiops.searchPanel.sampleProbabilityLabel",
  defaultMessage: "Sampling probability: {strongSamplingProbability}",
  values: {
    strongSamplingProbability: /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "aiopsSamplingProbability"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.searchPanel.sampleProbabilityNumber",
      defaultMessage: "{sampleProbability, plural, one {#} other {#}}",
      values: {
        sampleProbability
      }
    }))
  }
}))));
exports.TotalCountHeader = TotalCountHeader;