"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _aiopsComponents = require("@kbn/aiops-components");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _total_count_header = require("../total_count_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentCountContent = ({
  barColorOverride,
  barHighlightColorOverride,
  ...docCountChartProps
}) => {
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    documentStats
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const {
    sampleProbability,
    totalCount,
    documentCountStats
  } = documentStats;
  if (documentCountStats === undefined) {
    return totalCount !== undefined ? /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
      totalCount: totalCount,
      sampleProbability: sampleProbability
    }) : null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    sampleProbability: sampleProbability
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_aiopsComponents.DocumentCountChartRedux, (0, _extends2.default)({
    dependencies: {
      data,
      uiSettings,
      fieldFormats,
      charts
    },
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    changePoint: documentCountStats.changePoint
  }, docCountChartProps))));
};
exports.DocumentCountContent = DocumentCountContent;