"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorRoute = void 0;
var _common = require("../../../../common");
var _verify_access_and_context = require("../../verify_access_and_context");
var _response = require("../../../../common/routes/connector/response");
var _update = require("../../../../common/routes/connector/apis/update");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateConnectorRoute = (router, licenseState) => {
  router.put({
    path: `${_common.BASE_ACTION_API_PATH}/connector/{id}`,
    options: {
      access: 'public',
      summary: `Update a connector`,
      tags: ['oas-tag:connectors']
    },
    validate: {
      request: {
        body: _update.updateConnectorBodySchemaV1,
        params: _update.updateConnectorParamsSchemaV1
      },
      response: {
        200: {
          description: 'Indicates a successful call.',
          body: () => _response.connectorResponseSchemaV1
        }
      }
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    const {
      id
    } = req.params;
    const {
      name,
      config,
      secrets
    } = req.body;
    return res.ok({
      body: (0, _transforms.transformUpdateConnectorResponseV1)(await actionsClient.update({
        id,
        action: {
          name,
          config,
          secrets
        }
      }))
    });
  })));
};
exports.updateConnectorRoute = updateConnectorRoute;