"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteConnectorRoute = void 0;
var _common = require("../../../../common");
var _verify_access_and_context = require("../../verify_access_and_context");
var _delete = require("../../../../common/routes/connector/apis/delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteConnectorRoute = (router, licenseState) => {
  router.delete({
    path: `${_common.BASE_ACTION_API_PATH}/connector/{id}`,
    options: {
      access: 'public',
      summary: `Delete a connector`,
      description: 'WARNING: When you delete a connector, it cannot be recovered.',
      tags: ['oas-tag:connectors']
    },
    validate: {
      request: {
        params: _delete.deleteConnectorRequestParamsSchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    const {
      id
    } = req.params;
    await actionsClient.delete({
      id
    });
    return res.noContent();
  })));
};
exports.deleteConnectorRoute = deleteConnectorRoute;