"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConnectorRoute = void 0;
var _common = require("../../../../common");
var _verify_access_and_context = require("../../verify_access_and_context");
var _response = require("../../../../common/routes/connector/response");
var _common_transforms = require("../common_transforms");
var _create = require("../../../../common/routes/connector/apis/create");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createConnectorRoute = (router, licenseState) => {
  router.post({
    path: `${_common.BASE_ACTION_API_PATH}/connector/{id?}`,
    options: {
      access: 'public',
      summary: 'Create a connector',
      tags: ['oas-tag:connectors']
    },
    validate: {
      request: {
        params: _create.createConnectorRequestParamsSchemaV1,
        body: _create.createConnectorRequestBodySchemaV1
      },
      response: {
        200: {
          description: 'Indicates a successful call.',
          body: () => _response.connectorResponseSchemaV1
        }
      }
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    const action = (0, _transforms.transformCreateConnectorBodyV1)(req.body);
    return res.ok({
      body: (0, _common_transforms.transformConnectorResponseV1)(await actionsClient.create({
        action,
        options: req.params
      }))
    });
  })));
};
exports.createConnectorRoute = createConnectorRoute;