"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSystemActionKibanaPrivileges = getSystemActionKibanaPrivileges;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSystemActionKibanaPrivileges(context, connectorId, params) {
  const inMemoryConnector = context.inMemoryConnectors.find(connector => connector.id === connectorId);
  const additionalPrivileges = inMemoryConnector !== null && inMemoryConnector !== void 0 && inMemoryConnector.isSystemAction ? context.actionTypeRegistry.getSystemActionKibanaPrivileges(inMemoryConnector.actionTypeId, params) : [];
  return additionalPrivileges;
}