"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.execute = execute;
var _uuid = require("uuid");
var _get_system_action_kibana_privileges = require("../../../../lib/get_system_action_kibana_privileges");
var _is_preconfigured = require("../../../../lib/is_preconfigured");
var _is_system_action = require("../../../../lib/is_system_action");
var _get_authorization_mode_by_source = require("../../../../authorization/get_authorization_mode_by_source");
var _track_legacy_rbac_exemption = require("../../../../lib/track_legacy_rbac_exemption");
var _saved_objects = require("../../../../constants/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function execute(context, connectorExecuteParams) {
  const log = context.logger;
  const {
    actionId,
    params,
    source,
    relatedSavedObjects
  } = connectorExecuteParams;
  if ((await (0, _get_authorization_mode_by_source.getAuthorizationModeBySource)(context.unsecuredSavedObjectsClient, source)) === _get_authorization_mode_by_source.AuthorizationMode.RBAC) {
    const additionalPrivileges = (0, _get_system_action_kibana_privileges.getSystemActionKibanaPrivileges)(context, actionId, params);
    let actionTypeId;
    try {
      if ((0, _is_preconfigured.isPreconfigured)(context, actionId) || (0, _is_system_action.isSystemAction)(context, actionId)) {
        const connector = context.inMemoryConnectors.find(inMemoryConnector => inMemoryConnector.id === actionId);
        actionTypeId = connector === null || connector === void 0 ? void 0 : connector.actionTypeId;
      } else {
        // TODO: Optimize so we don't do another get on top of getAuthorizationModeBySource and within the actionExecutor.execute
        const {
          attributes
        } = await context.unsecuredSavedObjectsClient.get(_saved_objects.ACTION_SAVED_OBJECT_TYPE, actionId);
        actionTypeId = attributes.actionTypeId;
      }
    } catch (err) {
      log.debug(`Failed to retrieve actionTypeId for action [${actionId}]`, err);
    }
    await context.authorization.ensureAuthorized({
      operation: 'execute',
      additionalPrivileges,
      actionTypeId
    });
  } else {
    (0, _track_legacy_rbac_exemption.trackLegacyRBACExemption)('execute', context.usageCounter);
  }
  return context.actionExecutor.execute({
    actionId,
    params,
    source,
    request: context.request,
    relatedSavedObjects,
    actionExecutionId: (0, _uuid.v4)()
  });
}