"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiToastStyles = exports.euiToastHeaderStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _amsterdam = require("../../themes/amsterdam");
var _title = require("../title/title.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiToastStyles = exports.euiToastStyles = function euiToastStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiToast: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";", (0, _amsterdam.euiShadowLarge)(euiThemeContext), " position:relative;", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.base), " background-color:", euiTheme.colors.emptyShade, ";", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.euiTextBreakWord)(), "&:hover,&:focus{[class*='euiToast__closeButton']{opacity:1;}};label:euiToast;"),
    // Elements
    euiToast__closeButton: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('top', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('right', euiTheme.size.base), ";;label:euiToast__closeButton;"),
    // Variants
    primary: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', "2px solid ".concat(euiTheme.colors.primary)), ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', "2px solid ".concat(euiTheme.colors.success)), ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', "2px solid ".concat(euiTheme.colors.warning)), ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', "2px solid ".concat(euiTheme.colors.danger)), ";;label:danger;")
  };
};
var euiToastHeaderStyles = exports.euiToastHeaderStyles = function euiToastHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiToastHeader: /*#__PURE__*/(0, _react.css)("display:flex;align-items:baseline;", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.l), ">*+*{", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), ";};label:euiToastHeader;"),
    // Elements
    euiToastHeader__icon: /*#__PURE__*/(0, _react.css)("flex:0 0 auto;fill:", euiTheme.colors.title, ";transform:translateY(2px);;label:euiToastHeader__icon;"),
    euiToastHeader__title: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.bold, ";;label:euiToastHeader__title;"),
    // Variants
    withBody: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:withBody;")
  };
};