"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _responsive_context = require("./mobile/responsive_context");
var _table_row = require("./table_row.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "hasSelection", "isSelected", "isSelectable", "hasActions", "isExpandedRow", "isExpandable", "onClick"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiTableRow = exports.EuiTableRow = function EuiTableRow(_ref) {
  var children = _ref.children,
    className = _ref.className,
    hasSelection = _ref.hasSelection,
    isSelected = _ref.isSelected,
    isSelectable = _ref.isSelectable,
    hasActions = _ref.hasActions,
    isExpandedRow = _ref.isExpandedRow,
    isExpandable = _ref.isExpandable,
    onClick = _ref.onClick,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var styles = (0, _services.useEuiMemoizedStyles)(_table_row.euiTableRowStyles);
  var cssStyles = isResponsive ? [styles.euiTableRow, styles.mobile.mobile, isSelected && styles.mobile.selected, isExpandedRow && styles.mobile.expanded, (hasActions === true || isExpandable || isExpandedRow) && styles.mobile.hasRightColumn, hasSelection && styles.mobile.hasLeftColumn] : [styles.euiTableRow, styles.desktop.desktop, isSelected && styles.desktop.selected, isExpandedRow && styles.desktop.expanded, onClick && styles.desktop.clickable, isExpandedRow && hasSelection && styles.desktop.checkboxOffset];
  var classes = (0, _classnames.default)('euiTableRow', className, {
    'euiTableRow-isSelectable': isSelectable,
    'euiTableRow-isSelected': isSelected,
    'euiTableRow-hasActions': hasActions,
    'euiTableRow-isExpandedRow': isExpandedRow,
    'euiTableRow-isExpandable': isExpandable,
    'euiTableRow-isClickable': onClick
  });
  if (!onClick) {
    return (0, _react2.jsx)("tr", _extends({
      css: cssStyles,
      className: classes
    }, rest), children);
  }
  var onKeyDown = function onKeyDown(event) {
    // Prevent a scroll from occurring if the user has hit space.
    if (event.key === _services.keys.SPACE) event.preventDefault();
  };
  var onKeyUp = function onKeyUp(event) {
    // Support keyboard accessibility by emulating mouse click on ENTER or SPACE keypress.
    if (event.key === _services.keys.ENTER || event.key === _services.keys.SPACE) {
      onClick(event);
    }
  };
  return (0, _react2.jsx)("tr", _extends({
    css: cssStyles,
    className: classes,
    onClick: onClick,
    onKeyDown: onKeyDown,
    onKeyUp: onKeyUp,
    tabIndex: 0
  }, rest), children);
};
EuiTableRow.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Indicates if the table has a single column of checkboxes for selecting
     * rows (used for mobile styling)
     */
  hasSelection: _propTypes.default.bool,
  /**
     * Indicates that the current row's checkbox is selectable / not disabled
     */
  isSelectable: _propTypes.default.bool,
  /**
     * Indicates the current row has been selected
     */
  isSelected: _propTypes.default.bool,
  /**
     * Indicates if the table has a dedicated column for actions
     * (used for mobile styling and desktop action hover behavior)
     */
  hasActions: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["custom"])]),
  /**
     * Indicates if the row will have an expanded row
     */
  isExpandable: _propTypes.default.bool,
  /**
     * Indicates if the row will be the expanded row
     */
  isExpandedRow: _propTypes.default.bool,
  onClick: _propTypes.default.any
};