"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSelectableListItemVariables = exports.euiSelectableListItemStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiSelectableListItemVariables = exports.euiSelectableListItemVariables = function euiSelectableListItemVariables(_ref2) {
  var euiTheme = _ref2.euiTheme;
  var lighterBorder = (0, _services.transparentize)(euiTheme.border.color, 0.4);
  return {
    border: "".concat(euiTheme.border.width.thin, " solid ").concat(lighterBorder),
    paddingHorizontal: euiTheme.size.m,
    paddingVertical: euiTheme.size.xs
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1rnenrt-euiSelectableListItem__text",
  styles: "flex-grow:1;label:euiSelectableListItem__text;"
} : {
  name: "1rnenrt-euiSelectableListItem__text",
  styles: "flex-grow:1;label:euiSelectableListItem__text;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSelectableListItemStyles = exports.euiSelectableListItemStyles = function euiSelectableListItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiSelectableListIte = euiSelectableListItemVariables(euiThemeContext),
    border = _euiSelectableListIte.border,
    paddingHorizontal = _euiSelectableListIte.paddingHorizontal,
    paddingVertical = _euiSelectableListIte.paddingVertical;
  return {
    euiSelectableListItem: /*#__PURE__*/(0, _react.css)("display:inline-flex;", (0, _global_styling.logicalCSS)('width', '100%'), " line-height:", (0, _global_styling.euiFontSize)(euiThemeContext, 'm').lineHeight, ";font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";text-align:start;cursor:pointer;overflow:hidden;&:not(:last-of-type){", (0, _global_styling.logicalCSS)('border-bottom', border), ";}&[aria-disabled='true']{color:", euiTheme.colors.disabledText, ";cursor:not-allowed;}&:hover,&.euiSelectableListItem-isFocused{&:not([aria-disabled='true']){color:", euiTheme.colors.primaryText, ";background-color:", euiTheme.focus.backgroundColor, ";.euiSelectableListItem__text{text-decoration:underline;}}};label:euiSelectableListItem;"),
    padding: {
      none: /*#__PURE__*/(0, _react.css)(";label:none;"),
      s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-vertical', paddingVertical), " ", (0, _global_styling.logicalCSS)('padding-horizontal', paddingHorizontal), ";;label:s;")
    },
    // Child elements

    euiSelectableListItem__content: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), " display:flex;align-items:center;;label:euiSelectableListItem__content;"),
    euiSelectableListItem__text: _ref,
    textWrap: {
      truncate: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), ";label:truncate;"),
      wrap: /*#__PURE__*/(0, _react.css)(";label:wrap;")
    },
    euiSelectableListItem__prepend: /*#__PURE__*/(0, _react.css)("flex-shrink:0;", (0, _global_styling.logicalCSS)('margin-right', paddingHorizontal), ";;label:euiSelectableListItem__prepend;"),
    euiSelectableListItem__append: /*#__PURE__*/(0, _react.css)("flex-shrink:0;", (0, _global_styling.logicalCSS)('margin-left', paddingHorizontal), ";;label:euiSelectableListItem__append;"),
    get euiSelectableListItem__icon() {
      return this.euiSelectableListItem__prepend;
    }
  };
};