"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.popoverArrowSize = exports.euiPopoverArrowStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var popoverArrowSize = exports.popoverArrowSize = 'm';
var euiPopoverArrowStyles = exports.euiPopoverArrowStyles = function euiPopoverArrowStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var borderColor = 'var(--euiPopoverBackgroundColor)';
  var arrowSize = euiTheme.size[popoverArrowSize];
  return {
    // Base
    euiPopoverArrow: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalSizeCSS)(0, 0), "&::before{content:'';position:absolute;", (0, _global_styling.logicalSizeCSS)(0, 0), ";};label:euiPopoverArrow;"),
    // POSITIONS
    top: /*#__PURE__*/(0, _react.css)("&::before{", _global_styling.logicals.bottom, ":-", arrowSize, ";", _global_styling.logicals['border-left'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-right'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-top'], ":", arrowSize, " solid ", borderColor, ";};label:top;"),
    bottom: /*#__PURE__*/(0, _react.css)("&::before{", _global_styling.logicals.top, ":-", arrowSize, ";", _global_styling.logicals['border-left'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-right'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-bottom'], ":", arrowSize, " solid ", borderColor, ";};label:bottom;"),
    left: /*#__PURE__*/(0, _react.css)("&::before{", _global_styling.logicals.top, ":50%;", _global_styling.logicals.right, ":-", arrowSize, ";", _global_styling.logicals['border-top'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-bottom'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-left'], ":", arrowSize, " solid ", borderColor, ";};label:left;"),
    right: /*#__PURE__*/(0, _react.css)("&::before{", _global_styling.logicals.top, ":50%;", _global_styling.logicals.left, ":-", arrowSize, ";", _global_styling.logicals['border-top'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-bottom'], ":", arrowSize, " solid transparent;", _global_styling.logicals['border-right'], ":", arrowSize, " solid ", borderColor, ";};label:right;")
  };
};