"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiImageStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiImageStyles = exports.euiImageStyles = function euiImageStyles(euiThemeContext) {
  return {
    euiImage: /*#__PURE__*/(0, _react.css)("vertical-align:middle;", (0, _global_styling.logicalCSS)('max-width', '100%'), " &,[class*='euiText'] &{", (0, _global_styling.logicalCSS)('margin-bottom', 0), ";};label:euiImage;"),
    // Variations
    isFullScreen: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('max-height', '80vh'), " ", (0, _global_styling.logicalCSS)('max-width', '80vw'), ";;label:isFullScreen;"),
    hasShadow: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadow)(euiThemeContext, 's'), ";;label:hasShadow;"),
    // Sizes
    // These sizes are mostly suggestions. Don't look too hard for meaning in their values.
    // Size is applied to the image, rather than the wrapper figure to work better with floats
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100px'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '200px'), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '360px'), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '600px'), ";;label:xl;"),
    original: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', 'auto'), ";;label:original;"),
    fullWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:fullWidth;"),
    customSize: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', 'auto'), ";;label:customSize;")
  };
};