"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeClass = exports.EuiRange = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _number = require("../../../services/number");
var _popover = require("../../popover");
var _services = require("../../../services/");
var _eui_form_context = require("../eui_form_context");
var _range_levels_colors = require("./range_levels_colors");
var _range_highlight = require("./range_highlight");
var _range_input = require("./range_input");
var _range_label = require("./range_label");
var _range_slider = require("./range_slider");
var _range_tooltip = require("./range_tooltip");
var _range_track = require("./range_track");
var _range_wrapper = require("./range_wrapper");
var _range = require("./range.styles");
var _i18n = require("../../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["className", "compressed", "disabled", "fullWidth", "isLoading", "readOnly", "id", "max", "min", "name", "step", "showLabels", "showInput", "inputPopoverProps", "showTicks", "tickInterval", "ticks", "levels", "showRange", "showValue", "valueAppend", "valuePrepend", "onBlur", "onChange", "onFocus", "value", "tabIndex", "isInvalid", "theme"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiRangeClass = exports.EuiRangeClass = /*#__PURE__*/function (_Component) {
  function EuiRangeClass() {
    var _this;
    _classCallCheck(this, EuiRangeClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiRangeClass, [].concat(args));
    _defineProperty(_this, "preventPopoverClose", false);
    _defineProperty(_this, "state", {
      id: _this.props.id || (0, _services.htmlIdGenerator)()(),
      isPopoverOpen: false,
      trackWidth: 0
    });
    _defineProperty(_this, "handleOnChange", function (e) {
      var isValid = (0, _number.isWithinRange)(_this.props.min, _this.props.max, e.currentTarget.value);
      if (_this.props.onChange) {
        _this.props.onChange(e, isValid);
      }
    });
    _defineProperty(_this, "setTrackWidth", function (_ref) {
      var width = _ref.width;
      _this.setState({
        trackWidth: width
      });
    });
    _defineProperty(_this, "onInputFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }
      _this.setState({
        isPopoverOpen: true
      });
    });
    _defineProperty(_this, "onInputBlur", function (e) {
      return setTimeout(function () {
        // Safari does not recognize any focus-related eventing for input[type=range]
        // making it impossible to capture its state using active/focus/relatedTarget
        // Instead, a prevention flag is set on mousedown, with a waiting period here.
        // Mousedown is viable because in the popover case, it is inaccessible via keyboard (intentionally)
        if (_this.preventPopoverClose) {
          _this.preventPopoverClose = false;
          return;
        }
        if (_this.props.onBlur) {
          _this.props.onBlur(e);
        }
        _this.closePopover();
      }, 200);
    });
    _defineProperty(_this, "closePopover", function () {
      _this.preventPopoverClose = false;
      _this.setState({
        isPopoverOpen: false
      });
    });
    _defineProperty(_this, "handleAriaValueText", function (ticks, currentVal) {
      var target = ticks.find(function (tick) {
        return tick.value.toString() === currentVal.toString();
      });
      if (target) {
        return target.accessibleLabel ? "".concat(target.value, ", (").concat(target.accessibleLabel, ")") : typeof target.label === 'string' // Fall back to the label if it's a usable string
        ? "".concat(target.value, ", (").concat(target.label, ")") : undefined;
      }
    });
    return _this;
  }
  _inherits(EuiRangeClass, _Component);
  return _createClass(EuiRangeClass, [{
    key: "isValid",
    get: function get() {
      return (0, _number.isWithinRange)(this.props.min, this.props.max, this.props.value || '');
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref2 = this.context,
        defaultFullWidth = _ref2.defaultFullWidth;
      var _this$props = this.props,
        className = _this$props.className,
        compressed = _this$props.compressed,
        disabled = _this$props.disabled,
        _this$props$fullWidth = _this$props.fullWidth,
        fullWidth = _this$props$fullWidth === void 0 ? defaultFullWidth : _this$props$fullWidth,
        isLoading = _this$props.isLoading,
        readOnly = _this$props.readOnly,
        propsId = _this$props.id,
        max = _this$props.max,
        min = _this$props.min,
        name = _this$props.name,
        step = _this$props.step,
        showLabels = _this$props.showLabels,
        showInput = _this$props.showInput,
        inputPopoverProps = _this$props.inputPopoverProps,
        showTicks = _this$props.showTicks,
        tickInterval = _this$props.tickInterval,
        ticks = _this$props.ticks,
        levels = _this$props.levels,
        showRange = _this$props.showRange,
        showValue = _this$props.showValue,
        valueAppend = _this$props.valueAppend,
        valuePrepend = _this$props.valuePrepend,
        onBlur = _this$props.onBlur,
        onChange = _this$props.onChange,
        onFocus = _this$props.onFocus,
        value = _this$props.value,
        tabIndex = _this$props.tabIndex,
        isInvalid = _this$props.isInvalid,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var id = this.state.id;
      var showInputOnly = showInput === 'inputWithPopover';
      var canShowDropdown = showInputOnly && !readOnly && !disabled;
      var theInput = !!showInput ? (0, _react2.jsx)(_range_input.EuiRangeInput, _extends({
        id: id,
        min: min,
        max: max,
        step: step,
        value: value,
        readOnly: readOnly,
        disabled: disabled,
        compressed: compressed,
        onChange: this.handleOnChange,
        name: name,
        onFocus: canShowDropdown ? this.onInputFocus : onFocus,
        onBlur: canShowDropdown ? this.onInputBlur : onBlur,
        fullWidth: showInputOnly && fullWidth,
        isLoading: showInputOnly && isLoading,
        isInvalid: isInvalid,
        autoSize: !showInputOnly
      }, rest)) : null;
      var classes = (0, _classnames.default)('euiRange', className);
      var styles = (0, _range.euiRangeStyles)(theme);
      var cssStyles = [styles.euiRange, showInput && styles.hasInput];
      var thumbColor = levels && (0, _range_levels_colors.getLevelColor)(levels, Number(value));
      var sliderScreenReaderInstructions = (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiRange.sliderScreenReaderInstructions",
        default: "You are in a custom range slider. Use the Up and Down arrow keys to change the value."
      });
      var theRange = (0, _react2.jsx)(_range_wrapper.EuiRangeWrapper, {
        className: classes,
        css: cssStyles,
        fullWidth: fullWidth,
        compressed: compressed
      }, showLabels && (0, _react2.jsx)(_range_label.EuiRangeLabel, {
        side: "min",
        disabled: disabled
      }, min), (0, _react2.jsx)(_range_track.EuiRangeTrack, {
        trackWidth: this.state.trackWidth,
        disabled: disabled,
        compressed: compressed,
        max: max,
        min: min,
        step: step,
        showTicks: showTicks,
        tickInterval: tickInterval,
        ticks: ticks,
        levels: levels,
        onChange: this.handleOnChange,
        value: value,
        "aria-hidden": !!showInput,
        showRange: showRange
      }, (0, _react2.jsx)(_range_slider.EuiRangeSlider, _extends({
        ariaValueText: ticks ? this.handleAriaValueText(ticks, value) : undefined,
        id: showInput ? undefined : id // Attach id only to the input if there is one
        ,
        name: name,
        min: min,
        max: max,
        step: step,
        value: value,
        disabled: disabled,
        onChange: this.handleOnChange,
        showTicks: showTicks,
        showRange: showRange,
        tabIndex: showInput ? -1 : tabIndex,
        onMouseDown: showInputOnly ? function () {
          return _this2.preventPopoverClose = true;
        } : undefined,
        onFocus: showInput === true ? undefined : onFocus,
        onBlur: showInputOnly ? this.onInputBlur : onBlur,
        "aria-hidden": !!showInput,
        thumbColor: thumbColor
      }, rest, {
        onResize: this.setTrackWidth
      })), showRange && this.isValid && (0, _react2.jsx)(_range_highlight.EuiRangeHighlight, {
        showTicks: showTicks,
        min: Number(min),
        max: Number(max),
        lowerValue: Number(min),
        upperValue: Number(value),
        levels: levels,
        trackWidth: this.state.trackWidth
      }), showValue && !!String(value).length && (0, _react2.jsx)(_range_tooltip.EuiRangeTooltip, {
        value: value,
        max: max,
        min: min,
        name: name,
        showTicks: showTicks,
        valuePrepend: valuePrepend,
        valueAppend: valueAppend
      })), showLabels && (0, _react2.jsx)(_range_label.EuiRangeLabel, {
        side: "max",
        disabled: disabled
      }, max), showInput && !showInputOnly && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("div", {
        className: showTicks || ticks ? 'euiRange__slimHorizontalSpacer' : 'euiRange__horizontalSpacer',
        css: showTicks || ticks ? styles.euiRange__slimHorizontalSpacer : styles.euiRange__horizontalSpacer
      }), theInput));
      var thePopover = showInputOnly ? (0, _react2.jsx)(_popover.EuiInputPopover, _extends({}, inputPopoverProps, {
        className: (0, _classnames.default)('euiRange__popover', inputPopoverProps === null || inputPopoverProps === void 0 ? void 0 : inputPopoverProps.className),
        input: theInput // `showInputOnly` confirms existence
        ,
        fullWidth: fullWidth,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        disableFocusTrap: true,
        popoverScreenReaderText: sliderScreenReaderInstructions
      }), theRange) : undefined;
      return thePopover ? thePopover : theRange;
    }
  }]);
}(_react.Component);
_defineProperty(EuiRangeClass, "contextType", _eui_form_context.FormContext);
_defineProperty(EuiRangeClass, "defaultProps", {
  min: 0,
  max: 100,
  step: 1,
  compressed: false,
  isLoading: false,
  showLabels: false,
  showInput: false,
  showRange: false,
  showTicks: false,
  showValue: false,
  levels: []
});
EuiRangeClass.propTypes = {
  /**
     * Shows a tooltip styled value
     */
  showValue: _propTypes.default.bool,
  /**
     * Appends to the tooltip
     */
  valueAppend: _propTypes.default.node,
  /**
     * Prepends to the tooltip
     */
  valuePrepend: _propTypes.default.node,
  /**
     * Only impacts the input rendered by the `showInput` prop.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Only impacts the input rendered by the `showInput` prop.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired,
  onChange: _propTypes.default.func,
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  /**
     * The number to increment or decrement between each interval
     * @default 1
     */
  step: _propTypes.default.number,
  /**
     * Specified ticks at specified values
     */
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired,
    accessibleLabel: _propTypes.default.string
  }).isRequired),
  /**
     * Modifies the number of tick marks and at what interval
     */
  tickInterval: _propTypes.default.number,
  /**
     * Create colored indicators for certain intervals.
     * An array of #EuiRangeLevel objects
     */
  levels: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired),
  /**
     * Pass `true` to displays an extra input control for direct manipulation.
     * Pass `"inputWithPopover"` to only show the input but show the range in a dropdown.
     */
  showInput: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["inputWithPopover"])]),
  /**
     * Shows static min/max labels on the sides of the range slider
     */
  showLabels: _propTypes.default.bool,
  /**
     * Shows a thick line from min to value
     */
  showRange: _propTypes.default.bool,
  /**
     * Shows clickable tick marks and labels at the given interval (`step`/`tickInterval`)
     */
  showTicks: _propTypes.default.bool,
  id: _propTypes.default.string,
  name: _propTypes.default.string,
  /**
     * Only impacts ticks rendered by `showTicks` or inputs rendered by `showInput`.
     */
  compressed: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered by the `showInput` prop.
     * The range slider itself remains interactable unless `disabled` is applied.
     */
  readOnly: _propTypes.default.bool,
  /**
     * Disables both the range track and any input(s)
     */
  disabled: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered by the `showInput` prop
     */
  isInvalid: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`
     */
  isLoading: _propTypes.default.bool,
  /**
     * Only impacts input popovers rendered when the `showInput` prop is set to `"inputWithPopover"`
     *
     * Allows customizing the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element),
     * except for props controlled by the range component
     */
  inputPopoverProps: _propTypes.default.any
};
var EuiRange = exports.EuiRange = (0, _services.withEuiTheme)(EuiRangeClass);