"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFlyoutStyles = exports.euiFlyoutSlideInRight = exports.euiFlyoutSlideInLeft = exports.FLYOUT_BREAKPOINT = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _form = require("../form/form.styles");
var _templateObject, _templateObject2;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var FLYOUT_BREAKPOINT = exports.FLYOUT_BREAKPOINT = 'm';
var euiFlyoutSlideInRight = exports.euiFlyoutSlideInRight = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    opacity: 0;\n    transform: translateX(100%);\n  }\n  75% {\n    opacity: 1;\n    transform: translateX(0%);\n  }\n"])));
var euiFlyoutSlideInLeft = exports.euiFlyoutSlideInLeft = (0, _react.keyframes)(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n  0% {\n    opacity: 0;\n    transform: translateX(-100%);\n  }\n  75% {\n    opacity: 1;\n    transform: translateX(0%);\n  }\n"])));
var _ref = process.env.NODE_ENV === "production" ? {
  name: "yokctr-noAnimation",
  styles: "animation-duration:0s!important;label:noAnimation;"
} : {
  name: "yokctr-noAnimation",
  styles: "animation-duration:0s!important;label:noAnimation;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFlyoutStyles = exports.euiFlyoutStyles = function euiFlyoutStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlyout: /*#__PURE__*/(0, _react.css)("position:fixed;", (0, _global_styling.logicalCSS)('bottom', 0), " ", (0, _global_styling.logicalCSS)('top', 'var(--euiFixedHeadersOffset, 0)'), " ", (0, _global_styling.logicalCSS)('height', 'inherit'), " z-index:", euiTheme.levels.flyout, ";background:", euiTheme.colors.emptyShade, ";display:flex;flex-direction:column;align-items:stretch;&:focus{outline:none;}", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, FLYOUT_BREAKPOINT), "{", (0, _global_styling.logicalCSS)('max-width', '90vw !important'), ";};label:euiFlyout;"),
    // Flyout sizes
    s: /*#__PURE__*/(0, _react.css)(composeFlyoutSizing(euiThemeContext, 's'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)(composeFlyoutSizing(euiThemeContext, 'm'), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)(composeFlyoutSizing(euiThemeContext, 'l'), ";;label:l;"),
    noMaxWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', 'none'), ";;label:noMaxWidth;"),
    // Side
    right: /*#__PURE__*/(0, _react.css)("clip-path:polygon(-50% 0, 100% 0, 100% 100%, -50% 100%);", (0, _global_styling.logicalCSS)('right', 0), " ", _global_styling.euiCanAnimate, "{animation:", euiFlyoutSlideInRight, " ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ";};label:right;"),
    // Left-side flyouts should only be used for navigation
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', 0), " clip-path:polygon(0 0, 150% 0, 150% 100%, 0 100%);", _global_styling.euiCanAnimate, "{animation:", euiFlyoutSlideInLeft, " ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ";};label:left;"),
    // Type
    overlay: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowXLarge)(euiThemeContext), ";;label:overlay;"),
    push: {
      push: /*#__PURE__*/(0, _react.css)("clip-path:none;z-index:", Number(euiTheme.levels.flyout) - 1, ";;label:push;"),
      right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-left', euiTheme.border.thick), ";;label:right;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-right', euiTheme.border.thick), ";;label:left;"),
      noAnimation: _ref
    },
    // Padding
    paddingSizes: {
      none: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 'none'), ";;label:none;"),
      s: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 's'), ";;label:s;"),
      m: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 'm'), ";;label:m;"),
      l: /*#__PURE__*/(0, _react.css)(composeFlyoutPadding(euiThemeContext, 'l'), ";;label:l;")
    }
  };
};
var composeFlyoutSizing = function composeFlyoutSizing(euiThemeContext, size) {
  var euiTheme = euiThemeContext.euiTheme;
  var formMaxWidth = (0, _form.euiFormMaxWidth)(euiThemeContext);

  // 1. Calculating the minimum width based on the screen takeover breakpoint
  var flyoutSizes = {
    s: {
      min: "".concat(Math.round(euiTheme.breakpoint.m * 0.5), "px"),
      // 1.
      width: '25vw',
      max: "".concat(Math.round(euiTheme.breakpoint.s * 0.7), "px")
    },
    m: {
      // Calculated for forms plus padding
      min: "".concat((0, _global_styling.mathWithUnits)(formMaxWidth, function (x) {
        return x + 24;
      })),
      width: '50vw',
      max: "".concat(euiTheme.breakpoint.m, "px")
    },
    l: {
      min: "".concat(Math.round(euiTheme.breakpoint.m * 0.9), "px"),
      // 1.
      width: '75vw',
      max: "".concat(euiTheme.breakpoint.l, "px")
    }
  };
  return "\n    ".concat((0, _global_styling.logicalCSS)('max-width', flyoutSizes[size].max), "\n\n    ").concat((0, _global_styling.euiMaxBreakpoint)(euiThemeContext, FLYOUT_BREAKPOINT), " {\n      ").concat((0, _global_styling.logicalCSS)('min-width', 0), "\n      ").concat((0, _global_styling.logicalCSS)('width', flyoutSizes[size].min), "\n    }\n    ").concat((0, _global_styling.euiMinBreakpoint)(euiThemeContext, FLYOUT_BREAKPOINT), " {\n      ").concat((0, _global_styling.logicalCSS)('min-width', flyoutSizes[size].min), "\n      ").concat((0, _global_styling.logicalCSS)('width', flyoutSizes[size].width), "\n    }\n  ");
};
var composeFlyoutPadding = function composeFlyoutPadding(euiThemeContext, paddingSize) {
  var euiTheme = euiThemeContext.euiTheme;
  var paddingModifierMap = {
    none: 0,
    s: euiTheme.size.s,
    m: euiTheme.size.base,
    l: euiTheme.size.l
  };

  // Footer padding
  var footerPaddingSizes = {
    none: 0,
    s: euiTheme.size.s,
    m: "".concat((0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 0.75;
    }), " ").concat(euiTheme.size.base, ";"),
    l: "".concat((0, _global_styling.mathWithUnits)(euiTheme.size.l, function (x) {
      return x / 1.5;
    }), " ").concat(euiTheme.size.l, ";")
  };
  return "\n    .euiFlyoutHeader {\n      ".concat((0, _global_styling.logicalCSS)('padding-horizontal', paddingModifierMap[paddingSize]), "\n      ").concat((0, _global_styling.logicalCSS)('padding-top', paddingModifierMap[paddingSize]), "\n    }\n\n    [class*='euiFlyoutHeader-hasBorder'] {\n      ").concat((0, _global_styling.logicalCSS)('padding-bottom', paddingModifierMap[paddingSize]), "\n    }\n\n    .euiFlyoutBody__overflowContent {\n      padding: ").concat(paddingModifierMap[paddingSize], ";\n    }\n\n    .euiFlyoutBody__banner .euiCallOut {\n      ").concat((0, _global_styling.logicalCSS)('padding-horizontal', paddingModifierMap[paddingSize]), "\n    }\n\n    .euiFlyoutFooter {\n      padding: ").concat(footerPaddingSizes[paddingSize], ";\n    }\n  ");
};