"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFlyoutCloseButtonStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _services = require("../../services");
var _flyout = require("./flyout.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFlyoutCloseButtonStyles = exports.euiFlyoutCloseButtonStyles = function euiFlyoutCloseButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlyout__closeButton: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('right', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('top', euiTheme.size.s), " z-index:3;;label:euiFlyout__closeButton;"),
    inside: /*#__PURE__*/(0, _react.css)("background-color:", (0, _services.transparentize)(euiTheme.colors.emptyShade, 0.9), ";;label:inside;"),
    outside: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowXLarge)(euiThemeContext), "animation:none!important;;label:outside;"),
    outsideSide: {
      // `transforms` pull in close buttons a little
      // `!important` is necessary here to override the hover/focus transitions of buttons
      right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(-100% - ", euiTheme.size.xs, "))!important;}", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(-100% - ", euiTheme.size.l, "))!important;};label:right;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('right', 0), " ", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(100% + ", euiTheme.size.xs, "))!important;}", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, _flyout.FLYOUT_BREAKPOINT), "{transform:translateX(calc(100% + ", euiTheme.size.l, "))!important;};label:left;")
    }
  };
};