"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFacetButtonTextStyles = exports.euiFacetButtonStyles = exports.euiFacetButtonQuantityStyles = exports.euiFacetButtonLoadingSpinnerStyles = exports.euiFacetButtonIconStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiFacetButtonStyles = exports.euiFacetButtonStyles = function euiFacetButtonStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    // Base
    euiFacetButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('left'), " &:not(:disabled){&:hover,&:focus{text-decoration:none;.euiFacetButton__text{text-decoration:underline;}}&:focus .euiFacetButton__text{text-decoration-thickness:", euiTheme.border.width.thick, ";}}&:disabled{color:", euiTheme.colors.disabledText, ";pointer-events:none;};label:euiFacetButton;")
  };
};
var euiFacetButtonTextStyles = exports.euiFacetButtonTextStyles = function euiFacetButtonTextStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return {
    euiFacetButton__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextShift)('bold', 'data-text', euiTheme), " ", (0, _global_styling.euiTextTruncate)(), " flex-grow:1;;label:euiFacetButton__text;"),
    isSelected: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.bold, ";;label:isSelected;"),
    unSelected: /*#__PURE__*/(0, _react.css)(";label:unSelected;")
  };
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "mpq8zy-isDisabled",
  styles: "opacity:0.5;label:isDisabled;"
} : {
  name: "mpq8zy-isDisabled",
  styles: "opacity:0.5;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFacetButtonIconStyles = exports.euiFacetButtonIconStyles = function euiFacetButtonIconStyles() {
  return {
    euiFacetButton__icon: /*#__PURE__*/(0, _react.css)(";label:euiFacetButton__icon;"),
    isDisabled: _ref2
  };
};
var euiFacetButtonLoadingSpinnerStyles = exports.euiFacetButtonLoadingSpinnerStyles = function euiFacetButtonLoadingSpinnerStyles() {
  return {
    euiFacetButton__loadingSpinner: /*#__PURE__*/(0, _react.css)(";label:euiFacetButton__loadingSpinner;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "mpq8zy-isDisabled",
  styles: "opacity:0.5;label:isDisabled;"
} : {
  name: "mpq8zy-isDisabled",
  styles: "opacity:0.5;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFacetButtonQuantityStyles = exports.euiFacetButtonQuantityStyles = function euiFacetButtonQuantityStyles() {
  return {
    euiFacetButton__quantity: /*#__PURE__*/(0, _react.css)(";label:euiFacetButton__quantity;"),
    isDisabled: _ref
  };
};