"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDraggable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dnd = require("@hello-pangea/dnd");
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _droppable = require("./droppable");
var _draggable = require("./draggable.styles");
var _portal = require("../portal");
var _react2 = require("@emotion/react");
var _excluded = ["customDragHandle", "draggableId", "isDragDisabled", "hasInteractiveChildren", "isRemovable", "usePortal", "index", "children", "className", "spacing", "style", "data-test-subj"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiDraggable = exports.EuiDraggable = function EuiDraggable(_ref) {
  var _ref$customDragHandle = _ref.customDragHandle,
    customDragHandle = _ref$customDragHandle === void 0 ? false : _ref$customDragHandle,
    draggableId = _ref.draggableId,
    _ref$isDragDisabled = _ref.isDragDisabled,
    isDragDisabled = _ref$isDragDisabled === void 0 ? false : _ref$isDragDisabled,
    _ref$hasInteractiveCh = _ref.hasInteractiveChildren,
    hasInteractiveChildren = _ref$hasInteractiveCh === void 0 ? false : _ref$hasInteractiveCh,
    _ref$isRemovable = _ref.isRemovable,
    isRemovable = _ref$isRemovable === void 0 ? false : _ref$isRemovable,
    _ref$usePortal = _ref.usePortal,
    usePortal = _ref$usePortal === void 0 ? false : _ref$usePortal,
    index = _ref.index,
    children = _ref.children,
    className = _ref.className,
    _ref$spacing = _ref.spacing,
    spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
    style = _ref.style,
    _ref$dataTestSubj = _ref['data-test-subj'],
    dataTestSubj = _ref$dataTestSubj === void 0 ? 'draggable' : _ref$dataTestSubj,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_droppable.EuiDroppableContext),
    cloneItems = _useContext.cloneItems;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _draggable.euiDraggableStyles)(euiTheme);
  return (0, _react2.jsx)(_dnd.Draggable, _extends({
    draggableId: draggableId,
    index: index,
    isDragDisabled: isDragDisabled
  }, rest), function (provided, snapshot, rubric) {
    var _provided$dragHandleP, _provided$dragHandleP2;
    var isDragging = snapshot.isDragging;
    var cssStyles = [styles.euiDraggable, cloneItems && !isDragging && styles.hasClone, isDragging && styles.isDragging, isRemovable && styles.isRemovable, styles.spacing[spacing]];
    var classes = (0, _classnames.default)('euiDraggable', className);
    var childClasses = (0, _classnames.default)('euiDraggable__item', {
      'euiDraggable__item-isDisabled': isDragDisabled
    });
    var DraggableElement = typeof children === 'function' ? children(provided, snapshot, rubric) : children;
    var content = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("div", _extends({}, provided.draggableProps, !customDragHandle ? provided.dragHandleProps : {}, {
      ref: provided.innerRef,
      "data-test-subj": dataTestSubj,
      className: classes,
      css: cssStyles,
      style: _objectSpread(_objectSpread({}, style), provided.draggableProps.style)
      // We use [role="group"] instead of [role="button"] when we expect a nested
      // interactive element. Screen readers will cue users that this is a container
      // and has one or more elements inside that are part of a related group.
      ,
      role: hasInteractiveChildren ? 'group' : (_provided$dragHandleP = provided.dragHandleProps) === null || _provided$dragHandleP === void 0 ? void 0 : _provided$dragHandleP.role
      // If the container includes an interactive element, we remove the tabindex=0
      // because [role="group"] does not permit or warrant a tab stop
      ,
      tabIndex: hasInteractiveChildren ? undefined : (_provided$dragHandleP2 = provided.dragHandleProps) === null || _provided$dragHandleP2 === void 0 ? void 0 : _provided$dragHandleP2.tabIndex
    }), (0, _services.cloneElementWithCss)(DraggableElement, {
      className: (0, _classnames.default)(DraggableElement.props.className, childClasses),
      css: [_draggable.euiDraggableItemStyles.euiDraggable__item, isDragDisabled && _draggable.euiDraggableItemStyles.disabled]
    })), cloneItems && isDragging && (0, _react2.jsx)("div", {
      className: (0, _classnames.default)(classes, 'euiDraggable--clone'),
      css: cssStyles
    }, DraggableElement));
    return isDragging && usePortal ? (0, _react2.jsx)(_portal.EuiPortal, null, content) : content;
  });
};
EuiDraggable.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.any.isRequired]).isRequired,
  className: _propTypes.default.string,
  /**
     * Whether the `children` will provide and set up its own drag handle
     */
  customDragHandle: _propTypes.default.bool,
  /**
     * Whether the container has interactive children and should have `role="group"` instead of `"button"`.
     * Setting this flag ensures your drag & drop container is keyboard and screen reader accessible.
     */
  hasInteractiveChildren: _propTypes.default.bool,
  /**
     * Whether the item is currently in a position to be removed
     */
  isRemovable: _propTypes.default.bool,
  /**
     * Whether the currently dragged item is cloned into a portal in the body. This settings will
     * ensure that drag & drop still works as expected within stacking contexts (e.g. within `EuiFlyout`,
     * `EuiModal` and `EuiPopover`).
     *
     * Make sure to apply styles directly to the Draggable content as relative styling from an outside
     * scope might not be applied when the content is placed in a portal as the DOM structure changes.
     */
  usePortal: _propTypes.default.bool,
  /**
     * Adds padding to the draggable item
     */
  spacing: _propTypes.default.any,
  style: _propTypes.default.any,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};