"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridVariables = exports.euiDataGridStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridVariables = exports.euiDataGridVariables = function euiDataGridVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    cellPadding: {
      s: euiTheme.size.xs,
      m: (0, _global_styling.mathWithUnits)(euiTheme.size.m, function (x) {
        return x / 2;
      }),
      l: euiTheme.size.s
    },
    lineHeight: {
      s: (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').lineHeight,
      m: (0, _global_styling.euiFontSize)(euiThemeContext, 'm').lineHeight
    },
    fontSize: {
      s: (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize,
      m: (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize
    },
    levels: {
      cellPopover: Number(euiTheme.levels.header),
      // Same z-index as EuiFlyout mask overlays - cell popovers should be under both modal and flyout overlays
      get stickyHeader() {
        return this.cellPopover - 1; // Needs to sit above the content + cell focus outlines/actions, but below actual popovers
      }
    }
  };
};
var euiDataGridStyles = exports.euiDataGridStyles = function euiDataGridStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var _euiDataGridVariables = euiDataGridVariables(euiThemeContext),
    _cellPadding = _euiDataGridVariables.cellPadding,
    lineHeight = _euiDataGridVariables.lineHeight,
    _fontSize = _euiDataGridVariables.fontSize;
  return {
    euiDataGrid: /*#__PURE__*/(0, _react.css)("display:flex;flex-direction:column;align-items:stretch;", (0, _global_styling.logicalCSS)('height', '100%'), " overflow:hidden;*:where(& .euiDataGridRow){background-color:", euiTheme.colors.emptyShade, ";}*:where(&.euiDataGrid--stripes .euiDataGridRow--striped){background-color:", euiTheme.colors.lightestShade, ";}*:where(&.euiDataGrid--rowHoverHighlight .euiDataGridRow:hover){background-color:", euiTheme.colors.highlight, ";};label:euiDataGrid;"),
    cellPadding: {
      cellPadding: function cellPadding(size) {
        return /*#__PURE__*/(0, _react.css)(".euiDataGridHeaderCell,.euiDataGridRowCell__content{padding:", _cellPadding[size], ";}/* Workaround to trim line-clamp and padding - @see https://github.com/elastic/eui/issues/7780 */.euiDataGridRowCell__content--lineCountHeight{", (0, _global_styling.logicalCSS)('padding-bottom', 0), " ", (0, _global_styling.logicalCSS)('border-bottom', "".concat(_cellPadding[size], " solid transparent")), ";}.euiDataGridHeaderCell__button{margin-block:-", _cellPadding[size], ";};label:cellPadding;");
      },
      get s() {
        return /*#__PURE__*/(0, _react.css)(this.cellPadding('s'), ";label:s;");
      },
      get m() {
        return /*#__PURE__*/(0, _react.css)(this.cellPadding('m'), ";label:m;");
      },
      get l() {
        return /*#__PURE__*/(0, _react.css)(this.cellPadding('l'), ";label:l;");
      }
    },
    fontSize: {
      fontSize: function fontSize(size) {
        return /*#__PURE__*/(0, _react.css)(".euiDataGridHeaderCell,.euiDataGridRowCell{font-size:", _fontSize[size], ";line-height:", lineHeight[size], ";};label:fontSize;");
      },
      get s() {
        return /*#__PURE__*/(0, _react.css)(this.fontSize('s'), ";label:s;");
      },
      get m() {
        return /*#__PURE__*/(0, _react.css)(this.fontSize('m'), ";label:m;");
      },
      get l() {
        // On the Amsterdam theme, the l fontSize is the same as m
        return /*#__PURE__*/(0, _react.css)(this.fontSize('m'), ";label:l;");
      }
    },
    borders: {
      none: null,
      horizontal: /*#__PURE__*/(0, _react.css)("label:borders;.euiDataGridRowCell:not(.euiDataGridFooterCell),.euiDataGridFooter,&:not(.euiDataGrid--headerUnderline) .euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), ";}&:not(.euiDataGrid--footerOverline) .euiDataGridFooter{", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), " ", (0, _global_styling.logicalCSS)('margin-top', "-".concat(euiTheme.border.width.thin)), ";}.euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), ";};label:horizontal;"),
      all: /*#__PURE__*/(0, _react.css)("label:borders;.euiDataGridRowCell{&:not(.euiDataGridFooterCell){", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), " ", (0, _global_styling.logicalCSS)('border-right', // Visually lighten vertical borders
      "".concat(euiTheme.border.width.thin, " solid ").concat((0, _services.tintOrShade)(euiTheme.border.color, 0.3, colorMode))), ";}&--firstColumn{", (0, _global_styling.logicalCSS)('border-left', euiTheme.border.thin), ";}&--lastColumn{", (0, _global_styling.logicalCSS)('border-right-color', euiTheme.border.color), ";}}.euiDataGridFooterCell,.euiDataGridHeaderCell{", (0, _global_styling.logicalCSS)('border-right', euiTheme.border.thin), " &:first-of-type{", (0, _global_styling.logicalCSS)('border-left', euiTheme.border.thin), ";}}.euiDataGridFooter{", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), ";}&:not(.euiDataGrid--footerOverline) .euiDataGridFooter{", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), " ", (0, _global_styling.logicalCSS)('margin-top', "-".concat(euiTheme.border.width.thin)), ";}&:not(.euiDataGrid--headerUnderline) .euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), ";}&:is(.euiDataGrid--noControls) .euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), ";}.euiDataGrid__controls{border:", euiTheme.border.thin, ";background-color:", euiTheme.colors.body, ";};label:all;")
    },
    // Sits below the controls above it and pagination below it
    euiDataGrid__content: /*#__PURE__*/(0, _react.css)("z-index:1;position:relative;flex-grow:1;", (0, _global_styling.logicalSizeCSS)('100%'), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " overflow:hidden;background-color:", euiTheme.colors.body, ";font-feature-settings:'tnum' 1;;label:euiDataGrid__content;"),
    // Wrapper around EuiDataGrid
    euiDataGrid__focusWrap: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), ";;label:euiDataGrid__focusWrap;")
  };
};