"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridToolbarStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridToolbarStyles = exports.euiDataGridToolbarStyles = function euiDataGridToolbarStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiDataGrid__controls: /*#__PURE__*/(0, _react.css)("z-index:2;position:relative;display:flex;justify-content:space-between;align-items:center;gap:", euiTheme.size.base, ";", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.xs), " background-color:", euiTheme.colors.emptyShade, ";;label:euiDataGrid__controls;"),
    euiDataGrid__rightControls: /*#__PURE__*/(0, _react.css)("display:flex;justify-content:flex-end;flex-wrap:wrap;column-gap:", euiTheme.size.s, ";", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.xs), "&:only-child{", (0, _global_styling.logicalCSS)('margin-left', 'auto'), ";};label:euiDataGrid__rightControls;"),
    euiDataGrid__leftControls: /*#__PURE__*/(0, _react.css)("display:flex;flex-wrap:wrap;gap:", euiTheme.size.xxs, ";;label:euiDataGrid__leftControls;")
  };
};