"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridHeaderCellWrapperStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _data_grid_cell = require("../cell/data_grid_cell.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Styles that apply to both control and non-control columns
 */
var euiDataGridHeaderCellWrapperStyles = exports.euiDataGridHeaderCellWrapperStyles = function euiDataGridHeaderCellWrapperStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridCellOutli = (0, _data_grid_cell.euiDataGridCellOutlineStyles)(euiThemeContext),
    focusStyles = _euiDataGridCellOutli.focusStyles,
    hoverStyles = _euiDataGridCellOutli.hoverStyles;
  var _euiDataGridCellOutli2 = (0, _data_grid_cell.euiDataGridCellOutlineSelectors)(),
    outlineSelectors = _euiDataGridCellOutli2.header;
  var _sharedFlexCss = /*#__PURE__*/(0, _react.css)("display:flex;align-items:center;gap:", euiTheme.size.xxs, ";");
  return {
    euiDataGridHeaderCell: /*#__PURE__*/(0, _react.css)("position:relative;", _sharedFlexCss, " flex:0 0 auto;font-weight:", euiTheme.font.weight.bold, ";", outlineSelectors.focus, "{", focusStyles, ";}", outlineSelectors.focusTrapped, "{", hoverStyles, ";}&>[data-focus-lock-disabled]{", _sharedFlexCss, " ", (0, _global_styling.logicalCSS)('width', '100%'), ";};label:euiDataGridHeaderCell;")
  };
};