"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiHueStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _range = require("../form/range/range.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiHueStyles = exports.euiHueStyles = function euiHueStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var height = euiTheme.size.m;
  var thumbSize = euiTheme.size.l;
  var thumbBorder = (0, _global_styling.mathWithUnits)(euiTheme.border.width.thick, function (x) {
    return x * 1.5;
  });
  var thumbBoxShadow = "\n    0 2px 2px -1px ".concat((0, _services.transparentize)(euiTheme.colors.shadow, 0.2), ",\n    0 1px 5px -2px ").concat((0, _services.transparentize)(euiTheme.colors.shadow, 0.2));
  return {
    // This wraps the range and sets a rainbow gradient,
    // which allows the range thumb to be larger than the visible track
    euiHue: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', height), " border-radius:", height, ";background:linear-gradient(\n        to right,\n        #ff3232 0%,\n        #fff130 20%,\n        #45ff30 35%,\n        #28fff0 52%,\n        #282cff 71%,\n        #ff28fb 88%,\n        #ff0094 100%\n      );;label:euiHue;"),
    euiHue__range: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', thumbSize), (0, _global_styling.logicalCSS)('width', "calc(100% + 2px)"), (0, _global_styling.logicalCSS)('margin-horizontal', '-1px'), " ", (0, _global_styling.logicalCSS)('margin-top', (0, _global_styling.mathWithUnits)(height, function (x) {
      return x / -2;
    })), "appearance:none;background:transparent;&::-webkit-slider-thumb{-webkit-appearance:none;}", (0, _range.euiRangeThumbPerBrowser)([(0, _range.euiRangeThumbStyle)(euiThemeContext), 'background-color: inherit', "border-width: ".concat(thumbBorder), 'border-radius: 100%', "box-shadow: ".concat(thumbBoxShadow)].join(';\n')), "&:focus{outline:none;}&:focus-visible{", (0, _range.euiRangeThumbPerBrowser)((0, _range.euiRangeThumbFocusBoxShadow)(euiThemeContext)), ";};label:euiHue__range;")
  };
};