"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFullScreen = exports.EuiCodeBlockFullScreenWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _button = require("../button");
var _focus_trap = require("../focus_trap");
var _overlay_mask = require("../overlay_mask");
var _code_block = require("./code_block.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /**
 * Hook that returns fullscreen-related state/logic/utils
 */
var useFullScreen = exports.useFullScreen = function useFullScreen(_ref) {
  var overflowHeight = _ref.overflowHeight;
  var showFullScreenButton = !!overflowHeight;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var toggleFullScreen = (0, _react.useCallback)(function () {
    setIsFullScreen(function (isFullScreen) {
      return !isFullScreen;
    });
  }, []);
  var onKeyDown = (0, _react.useCallback)(function (event) {
    if (event.key === _services.keys.ESCAPE) {
      // We need to make sure annotation Escape keypresses don't also cause fullscreen mode to close
      var focus = document.activeElement;
      var isAnnotationPopover = !!(focus !== null && focus !== void 0 && focus.dataset.popoverOpen) || !!(focus !== null && focus !== void 0 && focus.closest('[data-popover-open]'));
      if (!isAnnotationPopover) {
        event.preventDefault();
        event.stopPropagation();
        setIsFullScreen(false);
      }
    }
  }, []);
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiCodeBlockFullScreen.fullscreenCollapse', 'euiCodeBlockFullScreen.fullscreenExpand'], ['Collapse', 'Expand']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    fullscreenCollapse = _useEuiI18n2[0],
    fullscreenExpand = _useEuiI18n2[1];
  var fullScreenButton = (0, _react.useMemo)(function () {
    return showFullScreenButton ? (0, _react2.jsx)(_button.EuiButtonIcon, {
      className: "euiCodeBlock__fullScreenButton",
      onClick: toggleFullScreen,
      iconType: isFullScreen ? 'fullScreenExit' : 'fullScreen',
      color: "text",
      "aria-label": isFullScreen ? fullscreenCollapse : fullscreenExpand
    }) : null;
  }, [showFullScreenButton, toggleFullScreen, isFullScreen, fullscreenCollapse, fullscreenExpand]);
  return {
    fullScreenButton: fullScreenButton,
    isFullScreen: isFullScreen,
    onKeyDown: onKeyDown
  };
};

/**
 * Portalled full screen wrapper
 */
var EuiCodeBlockFullScreenWrapper = exports.EuiCodeBlockFullScreenWrapper = function EuiCodeBlockFullScreenWrapper(_ref2) {
  var children = _ref2.children;
  var styles = (0, _services.useEuiMemoizedStyles)(_code_block.euiCodeBlockStyles);
  var cssStyles = [styles.euiCodeBlock, styles.l,
  // Force fullscreen to use large font
  styles.isFullScreen];
  return (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, null, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    scrollLock: true,
    preventScrollOnFocus: true,
    clickOutsideDisables: true
  }, (0, _react2.jsx)("div", {
    className: "euiCodeBlockFullScreen",
    css: cssStyles
  }, children)));
};