"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeBlockAnnotation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _button = require("../../themes/amsterdam/global_styling/mixins/button");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _icon = require("../icon");
var _code_block_annotations = require("./code_block_annotations.style");
var _react2 = require("@emotion/react");
var _excluded = ["lineNumber", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiCodeBlockAnnotation = exports.EuiCodeBlockAnnotation = function EuiCodeBlockAnnotation(_ref) {
  var lineNumber = _ref.lineNumber,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiCodeBlockAnnotations.ariaLabel', 'Click to view a code annotation for line {lineNumber}', {
    lineNumber: lineNumber
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_code_block_annotations.euiCodeBlockAnnotationsStyles);
  var buttonIconFocusStyle = (0, _button.useEuiButtonFocusCSS)();
  var cssButtonIconStyles = [styles.euiCodeBlockAnnotation__buttonIcon, buttonIconFocusStyle];
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme,
    colorMode = _useEuiTheme.colorMode;
  var isDarkMode = colorMode === 'DARK';
  var iconColor = isDarkMode ? euiTheme.colors.ink : 'ghost';
  return (0, _react2.jsx)(_popover.EuiPopover, _extends({
    css: styles.euiCodeBlockAnnotation
  }, rest, {
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    button: (0, _react2.jsx)("button", {
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      },
      "aria-label": ariaLabel,
      css: cssButtonIconStyles,
      "data-test-subj": "euiCodeBlockAnnotationIcon"
    }, (0, _react2.jsx)(_icon.EuiIcon, {
      type: AnnotationInfoIcon,
      size: "s",
      color: iconColor
    })),
    zIndex: Number(euiTheme.levels.mask) + 1 // Ensure fullscreen annotation popovers sit above the mask
    ,
    anchorPosition: "downLeft",
    panelProps: {
      'data-test-subj': 'euiCodeBlockAnnotationPopover'
    }
  }), children);
};
EuiCodeBlockAnnotation.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  lineNumber: _propTypes.default.number.isRequired
};
var AnnotationInfoIcon = function AnnotationInfoIcon(props) {
  return (0, _react2.jsx)("svg", _extends({
    width: 11,
    height: 11,
    viewBox: "0 0 16 16",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), (0, _react2.jsx)("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M7.139 14l-.052-6.007H5V6.28h4.111l.052 6.007h1.915V14h-3.94zM6.712 3.38c0-.396.118-.725.354-.987S7.639 2 8.077 2c.438 0 .777.131 1.016.393.24.262.359.591.359.987 0 .39-.12.714-.359.972s-.578.388-1.016.388c-.438 0-.775-.13-1.011-.388-.236-.258-.354-.582-.354-.972z"
  }));
};