"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _card = require("./card");
var _icon = require("../icon");
var _flex = require("../flex");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var Card = function Card() {
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    card1Selected = _useState2[0],
    setCard1 = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    card2Selected = _useState4[0],
    setCard2 = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = _slicedToArray(_useState5, 2),
    card3Selected = _useState6[0],
    setCard3 = _useState6[1];
  var card1Clicked = function card1Clicked() {
    setCard1(!card1Selected);
  };
  var card2Clicked = function card2Clicked() {
    setCard2(!card2Selected);
  };
  var card3Clicked = function card3Clicked() {
    setCard3(!card3Selected);
  };
  var detailsClicked = function detailsClicked(e) {
    e.stopPropagation();
  };
  return (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "l"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_card.EuiCard, {
    "data-test-subj": "cy-card-1",
    icon: (0, _react2.jsx)(_icon.EuiIcon, {
      size: "xxl",
      type: "logoSketch"
    }),
    title: "Sketch",
    description: "Example of a short card description.",
    footer: (0, _react2.jsx)(_button.EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Sketch"
    }, "More details"),
    selectable: {
      onClick: card1Clicked,
      isSelected: card1Selected
    }
  })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_card.EuiCard, {
    icon: (0, _react2.jsx)(_icon.EuiIcon, {
      size: "xxl",
      type: "logoGCP"
    }),
    title: "Google",
    description: "Example of a longer card description. See how the footers stay lined up.",
    footer: (0, _react2.jsx)(_button.EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Google"
    }, "More details"),
    selectable: {
      onClick: card2Clicked,
      isSelected: card2Selected
    }
  })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_card.EuiCard, {
    icon: (0, _react2.jsx)(_icon.EuiIcon, {
      size: "xxl",
      type: "logoAerospike"
    }),
    title: "Not Adobe",
    description: "Example of a short card description.",
    footer: (0, _react2.jsx)(_button.EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Not Adobe"
    }, "More details"),
    selectable: {
      onClick: card3Clicked,
      isSelected: card3Selected
    }
  })));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(Card, null));
});
describe('EuiCard', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after clicking buttons', function () {
      cy.get('button[aria-checked="false"]').each(function ($el) {
        cy.wrap($el).click();
      });
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.get('div[data-test-subj="cy-card-1"]').find('button.euiButtonEmpty').focus();
      cy.realPress('Tab');
      cy.realPress('{enter}');
      cy.get('div[data-test-subj="cy-card-1"]').find('button.euiButton').should('have.attr', 'aria-checked', 'true');
      cy.checkAxe();
    });
  });
});