"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponsiveMax = exports.limitBreadcrumbs = exports.EuiBreadcrumbs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _services = require("../../services");
var _breadcrumb = require("./breadcrumb");
var _breadcrumb_content = require("./_breadcrumb_content");
var _breadcrumbs = require("./breadcrumbs.styles");
var _react2 = require("@emotion/react");
var _excluded = ["breadcrumbs", "className", "responsive", "truncate", "max", "type", "lastBreadcrumbIsCurrentPage"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var responsiveDefault = {
  xs: 1,
  s: 2,
  m: 4
};
var EuiBreadcrumbs = exports.EuiBreadcrumbs = function EuiBreadcrumbs(_ref) {
  var breadcrumbs = _ref.breadcrumbs,
    className = _ref.className,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? responsiveDefault : _ref$responsive,
    _ref$truncate = _ref.truncate,
    truncate = _ref$truncate === void 0 ? true : _ref$truncate,
    _ref$max = _ref.max,
    max = _ref$max === void 0 ? 5 : _ref$max,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'page' : _ref$type,
    _ref$lastBreadcrumbIs = _ref.lastBreadcrumbIsCurrentPage,
    lastBreadcrumbIsCurrentPage = _ref$lastBreadcrumbIs === void 0 ? true : _ref$lastBreadcrumbIs,
    rest = _objectWithoutProperties(_ref, _excluded);
  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumbs.nav.ariaLabel', 'Breadcrumbs');
  var breadcrumbsListStyles = (0, _services.useEuiMemoizedStyles)(_breadcrumbs.euiBreadcrumbsListStyles);
  var cssBreadcrumbsListStyles = [breadcrumbsListStyles.euiBreadcrumbs__list, truncate && breadcrumbsListStyles.isTruncated];
  var responsiveMax = useResponsiveMax(responsive, max);
  var visibleBreadcrumbs = (0, _react.useMemo)(function () {
    var shouldCollapseBreadcrumbs = responsiveMax && breadcrumbs.length > responsiveMax;
    return shouldCollapseBreadcrumbs ? limitBreadcrumbs(breadcrumbs, responsiveMax) : breadcrumbs;
  }, [breadcrumbs, responsiveMax]);
  var breadcrumbChildren = (0, _react.useMemo)(function () {
    return visibleBreadcrumbs.map(function (breadcrumb, index) {
      var _breadcrumb$truncate;
      var isFirstBreadcrumb = index === 0;
      var isLastBreadcrumb = index === visibleBreadcrumbs.length - 1;
      var isOnlyBreadcrumb = visibleBreadcrumbs.length === 1;
      var sharedProps = {
        type: type,
        truncate: (_breadcrumb$truncate = breadcrumb.truncate) !== null && _breadcrumb$truncate !== void 0 ? _breadcrumb$truncate : truncate
      };
      return breadcrumb.isCollapsedButton ? (0, _react2.jsx)(_breadcrumb.EuiBreadcrumbCollapsed, _extends({
        key: "collapsed"
      }, sharedProps, {
        isFirstBreadcrumb: isFirstBreadcrumb
      }), (0, _react2.jsx)(EuiBreadcrumbs, {
        breadcrumbs: breadcrumb.overflowBreadcrumbs,
        lastBreadcrumbIsCurrentPage: false,
        responsive: false,
        truncate: false,
        max: 0
      })) : (0, _react2.jsx)(_breadcrumb.EuiBreadcrumb, _extends({
        key: index
      }, sharedProps), (0, _react2.jsx)(_breadcrumb_content.EuiBreadcrumbContent, _extends({}, breadcrumb, sharedProps, {
        isFirstBreadcrumb: isFirstBreadcrumb,
        isLastBreadcrumb: isLastBreadcrumb,
        isOnlyBreadcrumb: isOnlyBreadcrumb,
        highlightLastBreadcrumb: isLastBreadcrumb && lastBreadcrumbIsCurrentPage,
        truncateLastBreadcrumb: isLastBreadcrumb && truncate && breadcrumb.truncate == null
      })));
    });
  }, [visibleBreadcrumbs, truncate, type, lastBreadcrumbIsCurrentPage]);
  return (0, _react2.jsx)("nav", _extends({
    "aria-label": ariaLabel,
    className: (0, _classnames.default)('euiBreadcrumbs', className)
  }, rest), (0, _react2.jsx)("ol", {
    className: "euiBreadcrumbs__list",
    css: cssBreadcrumbsListStyles
  }, breadcrumbChildren));
};
EuiBreadcrumbs.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.
     * Pass a custom #EuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.
     *
     * Pass `false` to turn this behavior off.
     *
     * Default: `{ xs: 1, s: 2, m: 4 }`
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.any.isRequired]),
  /**
     * Forces all breadcrumbs to single line and
     * truncates each breadcrumb to a particular width,
     * except for the last item
     */
  truncate: _propTypes.default.bool,
  /**
     * Collapses the inner items past the maximum set here
     * into a single ellipses item.
     * Omitting or passing a `0` value will show all breadcrumbs.
     */
  max: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),
  /**
     * The array of individual #EuiBreadcrumb items
     */
  breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    href: _propTypes.default.string,
    rel: _propTypes.default.string,
    onClick: _propTypes.default.func,
    /**
         * Visible label of the breadcrumb
         */
    text: _propTypes.default.node.isRequired,
    /**
         * Force a max-width on the breadcrumb text
         */
    truncate: _propTypes.default.bool,
    /**
         * @deprecated - if a custom color is wanted, use the `css` prop to pass custom css
         */
    color: _propTypes.default.any,
    /**
         * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
         */
    "aria-current": _propTypes.default.any,
    /**
         * Creates a breadcrumb that toggles a popover dialog. Takes any rendered node(s),
         * or a render function that will pass callback allowing you to close the
         * breadcrumb popover from within your popover content.
         *
         * If passed, both `href` and `onClick` will be ignored - the breadcrumb's
         * click behavior should only trigger a popover.
         */
    popoverContent: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.func.isRequired]),
    /**
         * Allows customizing the popover if necessary. Accepts any props that
         * [EuiPopover](/#/layout/popover) accepts, except for props that control state.
         */
    popoverProps: _propTypes.default.any
  }).isRequired).isRequired,
  /**
     * Determines breadcrumbs appearance, with `page` being the default styling.
     * Application breadcrumbs should only be once per page, in (e.g.) EuiHeader
     */
  type: _propTypes.default.oneOf(["page", "application"]),
  /**
     * Whether the last breadcrumb should be semantically highlighted as the
     * current page. (improves accessibility for screen readers users)
     * Defaults to true.
     */
  lastBreadcrumbIsCurrentPage: _propTypes.default.bool
};
var useResponsiveMax = exports.useResponsiveMax = function useResponsiveMax(responsive, max) {
  // Use the default object if they simply passed `true` for responsive
  var responsiveObject = _typeof(responsive) === 'object' ? responsive : responsiveDefault;

  // The max property collapses any breadcrumbs past the max quantity.
  // This is the same behavior we want for responsiveness.
  // So calculate the max value based on the combination of `max` and `responsive`
  var responsiveMax = max;

  // Set the calculated max to the number associated with the currentBreakpoint key if it exists
  var currentBreakpoint = (0, _services.useCurrentEuiBreakpoint)();
  if (responsive && currentBreakpoint && responsiveObject[currentBreakpoint]) {
    responsiveMax = responsiveObject[currentBreakpoint];
  }

  // Final check is to make sure max is used over a larger breakpoint value
  if (max && responsiveMax) {
    responsiveMax = max < responsiveMax ? max : responsiveMax;
  }
  return responsiveMax;
};
var limitBreadcrumbs = exports.limitBreadcrumbs = function limitBreadcrumbs(breadcrumbs, max) {
  var breadcrumbsAtStart = [];
  var breadcrumbsAtEnd = [];
  var limit = Math.min(max, breadcrumbs.length);
  var start = Math.floor(limit / 2);
  var overflowBreadcrumbs = breadcrumbs.slice(start, start + breadcrumbs.length - limit);
  for (var i = 0; i < limit; i++) {
    // We'll alternate with displaying breadcrumbs at the end and at the start, but be biased
    // towards breadcrumbs the end so that if max is an odd number, we'll have one more
    // breadcrumb visible at the end than at the beginning.
    var isEven = i % 2 === 0;

    // We're picking breadcrumbs from the front AND the back, so we treat each iteration as a
    // half-iteration.
    var normalizedIndex = Math.floor(i * 0.5);
    var indexOfBreadcrumb = isEven ? breadcrumbs.length - 1 - normalizedIndex : normalizedIndex;
    var breadcrumb = breadcrumbs[indexOfBreadcrumb];
    if (isEven) {
      breadcrumbsAtEnd.unshift(breadcrumb);
    } else {
      breadcrumbsAtStart.push(breadcrumb);
    }
  }
  return [].concat(breadcrumbsAtStart, [{
    isCollapsedButton: true,
    overflowBreadcrumbs: overflowBreadcrumbs
  }], breadcrumbsAtEnd);
};