"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChartsTheme = getChartsTheme;
const dark_theme_1 = require("./dark_theme");
const light_theme_1 = require("./light_theme");
const common_1 = require("../common");
const lightBackground = '#FFFFFF';
const darkBackground = '#0B1628';
const BOREALIS_LIGHT_THEME = (0, common_1.mergePartial)(light_theme_1.LIGHT_THEME, {
    background: {
        color: lightBackground,
        fallbackColor: lightBackground,
    },
});
const BOREALIS_DARK_THEME = (0, common_1.mergePartial)(dark_theme_1.DARK_THEME, {
    background: {
        color: darkBackground,
        fallbackColor: darkBackground,
    },
});
function getChartsTheme(theme, colorMode) {
    const { name, darkMode } = typeof theme !== 'string' ? theme : { name: theme, darkMode: colorMode === 'DARK' };
    if (name !== 'amsterdam' && name !== 'EUI_THEME_AMSTERDAM')
        return darkMode ? BOREALIS_DARK_THEME : BOREALIS_LIGHT_THEME;
    return darkMode ? dark_theme_1.DARK_THEME : light_theme_1.LIGHT_THEME;
}
//# sourceMappingURL=get_charts_theme.js.map